/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.pluginapi.util.CommandLineOption;
import org.rhq.modules.plugins.jbossas7.AS7CommandLine;
import org.rhq.modules.plugins.jbossas7.AS7Mode;
import org.rhq.modules.plugins.jbossas7.helper.HostPort;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HostConfiguration {
    public static final int DEFAULT_MGMT_PORT = 9990;
    private static final String BIND_ADDRESS_MANAGEMENT_SYSPROP = "jboss.bind.address.management";
    private static final String DOMAIN_MASTER_ADDRESS_SYSPROP = "jboss.domain.master.address";
    private static final String DOMAIN_MASTER_PORT_SYSPROP = "jboss.domain.master.port";
    private static final String SOCKET_BINDING_PORT_OFFSET_SYSPROP = "jboss.socket.binding.port-offset";
    private static final CommandLineOption BIND_ADDRESS_MANAGEMENT_OPTION = new CommandLineOption("bmanagement", null);
    private static final CommandLineOption MASTER_ADDRESS_OPTION = new CommandLineOption(null, "master-address");
    private static final CommandLineOption MASTER_PORT_OPTION = new CommandLineOption(null, "master-port");
    private final Log log = LogFactory.getLog(HostConfiguration.class);
    private Document document;
    private XPathFactory xpathFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostConfiguration(File hostXmlFile) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        FileInputStream is = new FileInputStream(hostXmlFile);
        try {
            this.document = builder.parse(is);
        }
        finally {
            ((InputStream)is).close();
        }
        this.xpathFactory = XPathFactory.newInstance();
    }

    public HostPort getManagementHostPort(AS7CommandLine commandLine, AS7Mode mode) {
        String value;
        String interfaceName;
        String portString;
        String interfaceExpression;
        String socketBindingName = this.obtainXmlPropertyViaXPath("//management/management-interfaces/http-interface/socket-binding/@http");
        String socketInterface = this.obtainXmlPropertyViaXPath("//management/management-interfaces/http-interface/socket/@interface");
        String portOffsetRaw = null;
        if (!socketInterface.isEmpty()) {
            interfaceExpression = this.obtainXmlPropertyViaXPath("//interfaces/interface[@name='" + socketInterface + "']/inet-address/@value");
            if (interfaceExpression.isEmpty()) {
                interfaceExpression = this.obtainXmlPropertyViaXPath("//interfaces/interface[@name='" + socketInterface + "']/loopback-address/@value");
            }
            portString = this.obtainXmlPropertyViaXPath("//management/management-interfaces/http-interface/socket/@port");
        } else if (socketBindingName.isEmpty()) {
            portString = this.obtainXmlPropertyViaXPath("//management/management-interfaces/http-interface/@port");
            interfaceName = this.obtainXmlPropertyViaXPath("//management/management-interfaces/http-interface/@interface");
            interfaceExpression = this.obtainXmlPropertyViaXPath("/server/interfaces/interface[@name='" + interfaceName + "']/inet-address/@value");
            if (interfaceExpression.isEmpty()) {
                interfaceExpression = this.obtainXmlPropertyViaXPath("/server/interfaces/interface[@name='" + interfaceName + "']/loopback-address/@value");
            }
        } else {
            portString = this.obtainXmlPropertyViaXPath("/server/socket-binding-group/socket-binding[@name='" + socketBindingName + "']/@port");
            interfaceName = this.obtainXmlPropertyViaXPath("/server/socket-binding-group/socket-binding[@name='" + socketBindingName + "']/@interface");
            String socketBindingGroupName = "standard-sockets";
            String xpathExpression = "/server/socket-binding-group[@name='" + socketBindingGroupName + "']/@port-offset";
            portOffsetRaw = this.obtainXmlPropertyViaXPath(xpathExpression);
            interfaceExpression = this.obtainXmlPropertyViaXPath("/server/interfaces/interface[@name='" + interfaceName + "']/inet-address/@value");
            if (interfaceExpression.isEmpty()) {
                interfaceExpression = this.obtainXmlPropertyViaXPath("/server/interfaces/interface[@name='" + interfaceName + "']/loopback-address/@value");
            }
        }
        HostPort hp = new HostPort();
        hp.host = !interfaceExpression.isEmpty() ? this.replaceDollarExpression(interfaceExpression, commandLine, "localhost") : "localhost";
        hp.port = 0;
        if (portString != null && !portString.isEmpty()) {
            String tmp = this.replaceDollarExpression(portString, commandLine, String.valueOf(9990));
            hp.port = Integer.valueOf(tmp);
        }
        if (portOffsetRaw != null && !portOffsetRaw.isEmpty()) {
            String portOffsetString = this.replaceDollarExpression(portOffsetRaw, commandLine, "0");
            Integer portOffset = Integer.valueOf(portOffsetString);
            hp.port += portOffset.intValue();
            hp.withOffset = true;
        }
        if (!hp.withOffset && mode == AS7Mode.STANDALONE && (value = (String)commandLine.getSystemProperties().get(SOCKET_BINDING_PORT_OFFSET_SYSPROP)) != null) {
            int offset = Integer.valueOf(value);
            hp.port += offset;
        }
        return hp;
    }

    public String getHostName() {
        String hostName = this.document.getDocumentElement().getAttribute("name");
        return hostName;
    }

    public HostPort getDomainControllerHostPort(AS7CommandLine commandLine) {
        HostPort hp;
        String remoteHost = this.obtainXmlPropertyViaXPath("/host/domain-controller/remote/@host");
        String portString = this.obtainXmlPropertyViaXPath("/host/domain-controller/remote/@port");
        if (!remoteHost.isEmpty() && !portString.isEmpty()) {
            hp = new HostPort(false);
            hp.host = this.replaceDollarExpression(remoteHost, commandLine, "localhost");
            portString = this.replaceDollarExpression(portString, commandLine, "9999");
            hp.port = Integer.parseInt(portString);
        } else {
            hp = new HostPort(true);
            hp.port = 9999;
        }
        return hp;
    }

    public String getManagementSecurityRealm() {
        String realm = this.obtainXmlPropertyViaXPath("//management/management-interfaces/http-interface/@security-realm");
        return realm;
    }

    public File getSecurityPropertyFile(File baseDir, AS7Mode mode, String realm) {
        String fileName = this.obtainXmlPropertyViaXPath("//security-realms/security-realm[@name='" + realm + "']/authentication/properties/@path");
        String relDir = this.obtainXmlPropertyViaXPath("//security-realms/security-realm[@name='" + realm + "']/authentication/properties/@relative-to");
        String dmode = mode == AS7Mode.STANDALONE ? "server" : "domain";
        File configDir = relDir.equals("jboss." + dmode + ".config.dir") ? new File(baseDir, "configuration") : new File(relDir);
        File securityPropertyFile = new File(configDir, fileName);
        return securityPropertyFile;
    }

    public String getDomainApiVersion() {
        for (Node childNode = this.document.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (childNode.getNodeType() != 1) continue;
            String xmlns = childNode.getAttributes().getNamedItem("xmlns").getTextContent();
            return xmlns.substring(xmlns.lastIndexOf(58) + 1);
        }
        return "";
    }

    public String obtainXmlPropertyViaXPath(String xpathExpression) {
        XPath xpath = this.xpathFactory.newXPath();
        try {
            XPathExpression expr = xpath.compile(xpathExpression);
            Object result = expr.evaluate(this.document, XPathConstants.STRING);
            return result.toString();
        }
        catch (XPathExpressionException e) {
            this.log.error((Object)("Evaluation of XPath expression failed: " + e.getMessage()));
            return null;
        }
    }

    protected String replaceDollarExpression(String value, AS7CommandLine commandLine, String lastResort) {
        String expression;
        if (!value.contains("${")) {
            return value;
        }
        value = value.substring(2, value.length() - 1);
        String fallback = lastResort;
        if (value.contains(":")) {
            int i = value.indexOf(":");
            expression = value.substring(0, i);
            fallback = i + 1 < value.length() ? value.substring(i + 1) : "";
        } else {
            expression = value;
        }
        String resolvedValue = null;
        if (expression.equals(BIND_ADDRESS_MANAGEMENT_SYSPROP)) {
            resolvedValue = commandLine.getClassOption(BIND_ADDRESS_MANAGEMENT_OPTION);
        } else if (expression.equals(DOMAIN_MASTER_ADDRESS_SYSPROP)) {
            resolvedValue = commandLine.getClassOption(MASTER_ADDRESS_OPTION);
        } else if (expression.equals(DOMAIN_MASTER_PORT_SYSPROP)) {
            resolvedValue = commandLine.getClassOption(MASTER_PORT_OPTION);
        }
        if (resolvedValue == null) {
            resolvedValue = (String)commandLine.getSystemProperties().get(expression);
        }
        if (resolvedValue == null) {
            resolvedValue = fallback;
        }
        return resolvedValue;
    }
}

