/*
 * Decompiled with CFR 0.152.
 */
package com.jboss.jbossnetwork.product.jbpm.handlers;

import com.jboss.jbossnetwork.product.jbpm.handlers.ActionHandlerException;
import java.io.File;
import java.io.IOException;

public class HandlerUtils {
    public static void checkIsSet(String parameterName, Object parameterValue) throws ActionHandlerException {
        if (parameterValue == null || "".equals(parameterValue)) {
            throw new ActionHandlerException("Parameter [" + parameterName + "] is not set.");
        }
    }

    public static String formatPath(String path) {
        String formattedPath;
        if (path == null) {
            formattedPath = "";
        } else {
            File file = new File(path);
            if (!file.isAbsolute()) {
                formattedPath = file.getPath();
            } else {
                try {
                    formattedPath = file.getCanonicalPath();
                }
                catch (IOException e) {
                    formattedPath = file.getAbsolutePath();
                }
            }
        }
        return formattedPath;
    }

    public static String encode(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(HandlerUtils.convertDigit(bytes[i] >> 4));
            sb.append(HandlerUtils.convertDigit(bytes[i] & 0xF));
        }
        return sb.toString();
    }

    public static char convertDigit(int value) {
        if ((value &= 0xF) >= 10) {
            return (char)(value - 10 + 97);
        }
        return (char)(value + 48);
    }

    public static void checkFilenameIsWriteable(String filename) throws ActionHandlerException {
        if (!HandlerUtils.getFile(filename).canWrite()) {
            throw new ActionHandlerException("[" + HandlerUtils.formatPath(filename) + "] cannot be written to.");
        }
    }

    public static void checkFilenameIsReadable(String filename) throws ActionHandlerException {
        if (!HandlerUtils.getFile(filename).canRead()) {
            throw new ActionHandlerException("[" + HandlerUtils.formatPath(filename) + "] cannot be read from.");
        }
    }

    public static void checkFilenameIsAbsolute(String filename) throws ActionHandlerException {
        if (!HandlerUtils.getFile(filename).isAbsolute()) {
            throw new ActionHandlerException("[" + HandlerUtils.formatPath(filename) + "] is not an absolute path.");
        }
    }

    public static void checkFilenameIsADirectory(String filename) throws ActionHandlerException {
        if (!HandlerUtils.getFile(filename).isDirectory()) {
            throw new ActionHandlerException("[" + HandlerUtils.formatPath(filename) + "] is not a directory.");
        }
    }

    public static void checkFilenameIsAFile(String filename) throws ActionHandlerException {
        if (!HandlerUtils.getFile(filename).isFile()) {
            throw new ActionHandlerException("[" + HandlerUtils.formatPath(filename) + "] is not a file.");
        }
    }

    public static void checkFilenameExists(String filename) throws ActionHandlerException {
        if (!HandlerUtils.getFile(filename).exists()) {
            throw new ActionHandlerException("[" + HandlerUtils.formatPath(filename) + "] does not exist.");
        }
    }

    public static void checkFilenameIsNotEmpty(String filename) throws ActionHandlerException {
        if (HandlerUtils.getFile(filename).length() == 0L) {
            throw new ActionHandlerException("[" + HandlerUtils.formatPath(filename) + "] is empty.");
        }
    }

    public static void checkFilenameDoesNotExist(String filename) throws ActionHandlerException {
        if (HandlerUtils.getFile(filename).exists()) {
            throw new ActionHandlerException("[" + HandlerUtils.formatPath(filename) + "] already exists.");
        }
    }

    private static File getFile(String filename) throws ActionHandlerException {
        return new File(filename);
    }
}

