/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.common.jbossas;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityDomainInfo {
    private final Log log = LogFactory.getLog(this.getClass());
    private Map<String, String> usersToPasswordsMap = new HashMap<String, String>();
    private Map<String, Set<String>> usersToRolesMap = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> rolesToUsersMap = new HashMap<String, Set<String>>();

    public SecurityDomainInfo(File usersPropsFile, File rolesPropsFile) throws Exception {
        this.parseUsersPropertiesFiles(usersPropsFile);
        this.parseRolesPropertiesFiles(rolesPropsFile);
    }

    public Set<String> getUsers(String role) {
        if (this.rolesToUsersMap.containsKey(role)) {
            return this.rolesToUsersMap.get(role);
        }
        return Collections.emptySet();
    }

    public Set<String> getRoles(String user) {
        if (!this.usersToRolesMap.containsKey(user)) {
            throw new IllegalArgumentException("No such user: " + user);
        }
        return this.usersToRolesMap.get(user);
    }

    public String getPassword(String user) {
        if (!this.usersToPasswordsMap.containsKey(user)) {
            throw new IllegalArgumentException("No such user: " + user);
        }
        return this.usersToPasswordsMap.get(user);
    }

    private void parseUsersPropertiesFiles(File usersPropsFile) throws Exception {
        Properties usersProps = this.parsePropertiesFile(usersPropsFile);
        for (Object userObj : usersProps.keySet()) {
            String user = (String)userObj;
            String password = usersProps.getProperty(user);
            this.usersToPasswordsMap.put(user, password);
            this.usersToRolesMap.put(user, new HashSet());
        }
    }

    private void parseRolesPropertiesFiles(File rolesPropsFile) throws Exception {
        Properties rolesProps = this.parsePropertiesFile(rolesPropsFile);
        for (Object userObj : rolesProps.keySet()) {
            Set<Object> rolesForUser;
            String user = (String)userObj;
            String roles = rolesProps.getProperty(user);
            String[] rolesArray = roles.split(",[ \t]*");
            if (rolesArray.length == 0) continue;
            if (this.usersToRolesMap.containsKey(user)) {
                rolesForUser = this.usersToRolesMap.get(user);
            } else {
                rolesForUser = new HashSet();
                this.usersToRolesMap.put(user, rolesForUser);
            }
            for (String role : rolesArray) {
                Set<Object> users;
                rolesForUser.add(role);
                if (this.rolesToUsersMap.containsKey(role)) {
                    users = this.rolesToUsersMap.get(role);
                } else {
                    users = new LinkedHashSet();
                    this.rolesToUsersMap.put(role, users);
                }
                users.add(user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties parsePropertiesFile(File propsFile) throws IOException {
        Properties props = new Properties();
        FileInputStream inputStream = new FileInputStream(propsFile);
        try {
            props.load(inputStream);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                this.log.error((Object)("Failed to close properties file " + propsFile));
            }
        }
        return props;
    }
}

