/*
 * Decompiled with CFR 0.152.
 */
package com.jboss.jbossnetwork.product.jbpm.handlers;

import com.jboss.jbossnetwork.product.jbpm.handlers.ActionHandlerException;
import com.jboss.jbossnetwork.product.jbpm.handlers.BaseHandler;
import com.jboss.jbossnetwork.product.jbpm.handlers.HandlerUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jbpm.graph.exe.ExecutionContext;

public class BackupAndReplaceFileActionHandler
extends BaseHandler {
    private static final String TRANSITION_ORIGINAL_FILE_NOT_FOUND = "originalFileNotFound";
    private String replacementFileLocation;
    private String originalFileLocation;
    private String backupFileLocation;
    private String destinationFileLocation;

    public void run(ExecutionContext executionContext) {
        try {
            try {
                HandlerUtils.checkFilenameExists(this.originalFileLocation);
            }
            catch (ActionHandlerException e) {
                this.skip(executionContext, e, "File not replaced, no changes were made in this step.", TRANSITION_ORIGINAL_FILE_NOT_FOUND);
                return;
            }
            HandlerUtils.checkFilenameIsAFile(this.originalFileLocation);
            HandlerUtils.checkFilenameIsWriteable(this.originalFileLocation);
            HandlerUtils.checkFilenameDoesNotExist(this.backupFileLocation);
            HandlerUtils.checkFilenameExists(this.replacementFileLocation);
            HandlerUtils.checkFilenameIsAFile(this.replacementFileLocation);
            HandlerUtils.checkFilenameIsWriteable(this.replacementFileLocation);
            this.updateDestinationFileLocation();
            this.rename(this.originalFileLocation, this.backupFileLocation);
        }
        catch (Throwable e) {
            this.error(executionContext, e, this.getErrorDescription() + " " + "No changes were made in this step.", "error");
            return;
        }
        try {
            this.rename(this.replacementFileLocation, this.destinationFileLocation);
        }
        catch (Throwable e) {
            this.error(executionContext, e, this.getErrorDescription() + " Changes were made in this step. " + "To return to the previous state you should rename [" + HandlerUtils.formatPath(this.getBackupFileLocation()) + "] to be [" + HandlerUtils.formatPath(this.getOriginalFileLocation()) + "].", "error");
            return;
        }
        this.complete(executionContext, "Successfully replaced [" + HandlerUtils.formatPath(this.getOriginalFileLocation()) + "]. Original file was backed up to [" + HandlerUtils.formatPath(this.getBackupFileLocation()) + "].");
    }

    public String getDescription() {
        return "Backup and replace [" + HandlerUtils.formatPath(this.originalFileLocation) + "].";
    }

    public void substituteVariables(ExecutionContext executionContext) throws ActionHandlerException {
        this.setReplacementFileLocation(this.substituteVariable(this.replacementFileLocation, executionContext));
        this.setOriginalFileLocation(this.substituteVariable(this.originalFileLocation, executionContext));
        this.setBackupFileLocation(this.substituteVariable(this.backupFileLocation, executionContext));
        this.setDestinationFileLocation(this.substituteVariable(this.destinationFileLocation, executionContext));
    }

    protected void checkProperties() throws ActionHandlerException {
        HandlerUtils.checkIsSet("originalFileLocation", this.originalFileLocation);
        HandlerUtils.checkIsSet("replacementFileLocation", this.replacementFileLocation);
        HandlerUtils.checkIsSet("backupFileLocation", this.backupFileLocation);
        HandlerUtils.checkIsSet("destinationFileLocation", this.destinationFileLocation);
    }

    public void setPropertyDefaults() {
        if (this.getBackupFileLocation() == null) {
            this.setBackupFileLocation(this.getOriginalFileLocation() + ".#{timestamp}.old");
        }
        if (this.getDestinationFileLocation() == null) {
            this.setDestinationFileLocation(this.getOriginalFileLocation());
        }
    }

    private void updateDestinationFileLocation() throws ActionHandlerException {
        File originalFile;
        String originalFilename;
        File replacementFile = new File(this.replacementFileLocation);
        String replacementFilename = replacementFile.getName();
        if (!replacementFilename.equalsIgnoreCase(originalFilename = (originalFile = new File(this.originalFileLocation)).getName())) {
            HandlerUtils.checkFilenameIsAbsolute(this.originalFileLocation);
            File destinationFile = new File(originalFile.getParentFile().getPath() + File.separator + replacementFilename);
            this.setDestinationFileLocation(destinationFile.getPath());
            HandlerUtils.checkFilenameDoesNotExist(this.destinationFileLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rename(String from, String to) throws ActionHandlerException, IOException {
        block8: {
            File fromFile = new File(from);
            File toFile = new File(to);
            if (!fromFile.renameTo(toFile)) {
                FileInputStream in = null;
                OutputStream out = null;
                try {
                    int len;
                    in = new FileInputStream(from);
                    out = new FileOutputStream(to);
                    byte[] buf = new byte[1024];
                    while ((len = ((InputStream)in).read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    if (toFile.exists()) {
                        fromFile.delete();
                        break block8;
                    }
                    throw new ActionHandlerException("Could not write from [" + HandlerUtils.formatPath(from) + "] to [" + HandlerUtils.formatPath(to) + "].");
                }
                finally {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
            }
        }
    }

    private String getErrorDescription() {
        String desc = "Trying to back-up [" + HandlerUtils.formatPath(this.getOriginalFileLocation()) + "] to [" + HandlerUtils.formatPath(this.getBackupFileLocation()) + "], then replace it with file from [" + HandlerUtils.formatPath(this.getReplacementFileLocation()) + "]";
        File replacementFile = new File(this.replacementFileLocation);
        File originalFile = new File(this.originalFileLocation);
        desc = !replacementFile.getName().equalsIgnoreCase(originalFile.getName()) ? desc + ", maintaining the replacement filename." : desc + ".";
        return desc;
    }

    public String getReplacementFileLocation() {
        return this.replacementFileLocation;
    }

    public void setReplacementFileLocation(String replacementFileLocation) {
        this.replacementFileLocation = replacementFileLocation;
    }

    public String getOriginalFileLocation() {
        return this.originalFileLocation;
    }

    public void setOriginalFileLocation(String originalFileLocation) {
        this.originalFileLocation = originalFileLocation;
    }

    public String getBackupFileLocation() {
        return this.backupFileLocation;
    }

    public void setBackupFileLocation(String backupFileLocation) {
        this.backupFileLocation = backupFileLocation;
    }

    public String getDestinationFileLocation() {
        return this.destinationFileLocation;
    }

    public void setDestinationFileLocation(String destinationFileLocation) {
        this.destinationFileLocation = destinationFileLocation;
    }
}

