/*
 * Decompiled with CFR 0.152.
 */
package com.jboss.jbossnetwork.product.jbpm.handlers;

import com.jboss.jbossnetwork.product.jbpm.handlers.ActionHandlerException;
import com.jboss.jbossnetwork.product.jbpm.handlers.BaseHandler;
import com.jboss.jbossnetwork.product.jbpm.handlers.HandlerUtils;
import java.io.File;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Expand;
import org.jbpm.graph.exe.ExecutionContext;

public class UnzipActionHandler
extends BaseHandler {
    private String fileToBeUnzippedLocation;
    private String destinationDirectoryLocation;

    @Override
    public void run(ExecutionContext executionContext) {
        try {
            HandlerUtils.checkFilenameExists(this.fileToBeUnzippedLocation);
            HandlerUtils.checkFilenameIsAFile(this.fileToBeUnzippedLocation);
            HandlerUtils.checkFilenameIsReadable(this.fileToBeUnzippedLocation);
            HandlerUtils.checkFilenameExists(this.destinationDirectoryLocation);
            HandlerUtils.checkFilenameIsADirectory(this.destinationDirectoryLocation);
            HandlerUtils.checkFilenameIsWriteable(this.destinationDirectoryLocation);
            this.unzip();
            this.complete(executionContext, "Successfully unzipped [" + HandlerUtils.formatPath(this.fileToBeUnzippedLocation) + "] to [" + HandlerUtils.formatPath(this.destinationDirectoryLocation) + "].");
        }
        catch (Throwable t) {
            this.error(executionContext, t, "No changes were made in this step.", "error");
        }
    }

    @Override
    public String getDescription() {
        return "Unzip [" + HandlerUtils.formatPath(this.fileToBeUnzippedLocation) + "] into [" + HandlerUtils.formatPath(this.destinationDirectoryLocation) + "].";
    }

    @Override
    protected void checkProperties() throws ActionHandlerException {
        HandlerUtils.checkIsSet("destinationDirectoryLocation", this.destinationDirectoryLocation);
        HandlerUtils.checkIsSet("fileToBeUnzippedLocation", this.fileToBeUnzippedLocation);
    }

    @Override
    public void substituteVariables(ExecutionContext executionContext) throws ActionHandlerException {
        this.setFileToBeUnzippedLocation(this.substituteVariable(this.fileToBeUnzippedLocation, executionContext));
        this.setDestinationDirectoryLocation(this.substituteVariable(this.destinationDirectoryLocation, executionContext));
    }

    private void unzip() throws ActionHandlerException {
        try {
            Expand expander = new Expand();
            expander.setProject(new Project());
            expander.setSrc(new File(this.fileToBeUnzippedLocation));
            expander.setDest(new File(this.destinationDirectoryLocation));
            expander.execute();
        }
        catch (Exception e) {
            throw new ActionHandlerException("Failed trying to unzip [" + HandlerUtils.formatPath(this.fileToBeUnzippedLocation) + "] to [" + HandlerUtils.formatPath(this.destinationDirectoryLocation) + "].", e);
        }
    }

    public String getFileToBeUnzippedLocation() {
        return this.fileToBeUnzippedLocation;
    }

    public void setFileToBeUnzippedLocation(String fileToBeUnzippedLocation) {
        this.fileToBeUnzippedLocation = fileToBeUnzippedLocation;
    }

    public String getDestinationDirectoryLocation() {
        return this.destinationDirectoryLocation;
    }

    public void setDestinationDirectoryLocation(String destinationDirectoryLocation) {
        this.destinationDirectoryLocation = destinationDirectoryLocation;
    }
}

