/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.common.jbossas.client.controller;

import java.io.File;
import java.util.List;
import java.util.Properties;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.rhq.common.jbossas.client.controller.Address;
import org.rhq.common.jbossas.client.controller.FailureException;
import org.rhq.common.jbossas.client.controller.JBossASClient;

public class CoreJBossASClient
extends JBossASClient {
    public static final String CORE_SERVICE = "core-service";
    public static final String SERVER_ENVIRONMENT = "server-environment";
    public static final String PLATFORM_MBEAN = "platform-mbean";
    public static final String DEPLOYMENT_SCANNER = "deployment-scanner";
    public static final String SCANNER = "scanner";
    public static final String EXTENSION = "extension";
    public static final String MODULE = "module";

    public CoreJBossASClient(ModelControllerClient client) {
        super(client);
    }

    public Properties getSystemProperties() throws Exception {
        String[] address = new String[]{CORE_SERVICE, PLATFORM_MBEAN, "type", "runtime"};
        ModelNode op = CoreJBossASClient.createReadAttributeRequest(true, "system-properties", Address.root().add(address));
        ModelNode results = this.execute(op);
        if (CoreJBossASClient.isSuccess(results)) {
            Properties sysprops = new Properties();
            ModelNode node = CoreJBossASClient.getResults(results);
            List propertyList = node.asPropertyList();
            for (Property property : propertyList) {
                String name = property.getName();
                ModelNode value = property.getValue();
                if (name == null) continue;
                sysprops.put(name, value != null ? value.asString() : "");
            }
            return sysprops;
        }
        throw new FailureException(results, "Failed to get system properties");
    }

    public String getOperatingSystem() throws Exception {
        String[] address = new String[]{CORE_SERVICE, PLATFORM_MBEAN, "type", "operating-system"};
        String osName = this.getStringAttribute("name", Address.root().add(address));
        return osName;
    }

    public String getAppServerVersion() throws Exception {
        String version = this.getStringAttribute("release-version", Address.root());
        return version;
    }

    public String getAppServerHomeDir() throws Exception {
        String[] address = new String[]{CORE_SERVICE, SERVER_ENVIRONMENT};
        String dir = this.getStringAttribute(true, "home-dir", Address.root().add(address));
        return dir;
    }

    public String getAppServerBaseDir() throws Exception {
        String[] address = new String[]{CORE_SERVICE, SERVER_ENVIRONMENT};
        String dir = this.getStringAttribute(true, "base-dir", Address.root().add(address));
        return dir;
    }

    public String getAppServerConfigDir() throws Exception {
        String[] address = new String[]{CORE_SERVICE, SERVER_ENVIRONMENT};
        String dir = this.getStringAttribute(true, "config-dir", Address.root().add(address));
        return dir;
    }

    public String getAppServerLogDir() throws Exception {
        String[] address = new String[]{CORE_SERVICE, SERVER_ENVIRONMENT};
        String dir = this.getStringAttribute(true, "log-dir", Address.root().add(address));
        return dir;
    }

    public String getAppServerTmpDir() throws Exception {
        String[] address = new String[]{CORE_SERVICE, SERVER_ENVIRONMENT};
        String dir = this.getStringAttribute(true, "temp-dir", Address.root().add(address));
        return dir;
    }

    public void setAppServerDefaultDeploymentScanEnabled(boolean enabled) throws Exception {
        String[] addressArr = new String[]{"subsystem", DEPLOYMENT_SCANNER, SCANNER, "default"};
        Address address = Address.root().add(addressArr);
        ModelNode req = CoreJBossASClient.createWriteAttributeRequest("scan-enabled", Boolean.toString(enabled), address);
        ModelNode response = this.execute(req);
        if (!CoreJBossASClient.isSuccess(response)) {
            throw new FailureException(response);
        }
    }

    public String getAppServerDefaultDeploymentDir() throws Exception {
        String[] addressArr = new String[]{"subsystem", DEPLOYMENT_SCANNER, SCANNER, "default"};
        Address address = Address.root().add(addressArr);
        ModelNode resourceAttributes = this.readResource(address);
        if (resourceAttributes == null) {
            return null;
        }
        String path = resourceAttributes.get("path").asString();
        String relativeTo = null;
        if (resourceAttributes.hasDefined("relative-to")) {
            relativeTo = resourceAttributes.get("relative-to").asString();
        }
        if (relativeTo != null) {
            String syspropValue = System.getProperty(relativeTo);
            if (syspropValue == null) {
                throw new IllegalStateException("Cannot support relative-to that isn't a sysprop: " + relativeTo);
            }
            relativeTo = syspropValue;
        }
        File dir = new File(relativeTo, path);
        return dir.getAbsolutePath();
    }

    public void setAppServerDefaultDeploymentScanInterval(long millis) throws Exception {
        String[] addressArr = new String[]{"subsystem", DEPLOYMENT_SCANNER, SCANNER, "default"};
        Address address = Address.root().add(addressArr);
        ModelNode req = CoreJBossASClient.createWriteAttributeRequest("scan-interval", Long.toString(millis), address);
        ModelNode response = this.execute(req);
        if (!CoreJBossASClient.isSuccess(response)) {
            throw new FailureException(response);
        }
    }

    public void setAppServerDefaultDeploymentTimeout(long secs) throws Exception {
        String[] addressArr = new String[]{"subsystem", DEPLOYMENT_SCANNER, SCANNER, "default"};
        Address address = Address.root().add(addressArr);
        ModelNode req = CoreJBossASClient.createWriteAttributeRequest("deployment-timeout", Long.toString(secs), address);
        ModelNode response = this.execute(req);
        if (!CoreJBossASClient.isSuccess(response)) {
            throw new FailureException(response);
        }
    }

    public void setSystemProperty(String name, String value) throws Exception {
        ModelNode request = CoreJBossASClient.createRequest("add", Address.root().add("system-property", name));
        request.get("value").set(value);
        ModelNode response = this.execute(request);
        if (!CoreJBossASClient.isSuccess(response)) {
            throw new FailureException(response, "Failed to set system property [" + name + "]");
        }
    }

    public void addExtension(String name) throws Exception {
        ModelNode request = CoreJBossASClient.createRequest("add", Address.root().add(EXTENSION, name));
        request.get(MODULE).set(name);
        ModelNode response = this.execute(request);
        if (!CoreJBossASClient.isSuccess(response)) {
            throw new FailureException(response, "Failed to add new module extension [" + name + "]");
        }
    }

    public boolean isExtension(String name) throws Exception {
        return null != this.readResource(Address.root().add(EXTENSION, name));
    }

    public void addSubsystem(String name) throws Exception {
        ModelNode request = CoreJBossASClient.createRequest("add", Address.root().add("subsystem", name));
        ModelNode response = this.execute(request);
        if (!CoreJBossASClient.isSuccess(response)) {
            throw new FailureException(response, "Failed to add new subsystem [" + name + "]");
        }
    }

    public boolean isSubsystem(String name) throws Exception {
        return null != this.readResource(Address.root().add("subsystem", name));
    }

    public void reload() throws Exception {
        this.reload(false);
    }

    public void reload(boolean adminOnly) throws Exception {
        ModelNode request = CoreJBossASClient.createRequest("reload", Address.root());
        request.get("admin-only").set(adminOnly);
        ModelNode response = this.execute(request);
        if (!CoreJBossASClient.isSuccess(response)) {
            throw new FailureException(response);
        }
    }

    public void restart() throws Exception {
        this.shutdown(true);
    }

    public void shutdown(boolean restart) throws Exception {
        ModelNode request = CoreJBossASClient.createRequest("shutdown", Address.root());
        request.get("restart").set(restart);
        ModelNode response = this.execute(request);
        if (!CoreJBossASClient.isSuccess(response)) {
            throw new FailureException(response);
        }
    }
}

