/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.common.jbossas.client.controller;

import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.rhq.common.jbossas.client.controller.Address;
import org.rhq.common.jbossas.client.controller.FailureException;
import org.rhq.common.jbossas.client.controller.JBossASClient;

public class DeploymentJBossASClient
extends JBossASClient {
    public static final String SUBSYSTEM_DEPLOYMENT = "deployment";
    public static final String ENABLED = "enabled";
    public static final String CONTENT = "content";
    public static final String PATH = "path";

    public DeploymentJBossASClient(ModelControllerClient client) {
        super(client);
    }

    public boolean isDeployment(String name) throws Exception {
        Address addr = Address.root().add(SUBSYSTEM_DEPLOYMENT, name);
        return null != this.readResource(addr);
    }

    public boolean isDeploymentEnabled(String name) throws Exception {
        Address addr = Address.root().add(SUBSYSTEM_DEPLOYMENT, name);
        ModelNode results = this.readResource(addr);
        if (results == null) {
            throw new IllegalArgumentException("There is no deployment with the name: " + name);
        }
        boolean enabledFlag = false;
        if (results.hasDefined(ENABLED)) {
            ModelNode enabled = results.get(ENABLED);
            enabledFlag = enabled.asBoolean(false);
        }
        return enabledFlag;
    }

    public void enableDeployment(String name) throws Exception {
        this.enableDisableDeployment(name, true);
    }

    public void disableDeployment(String name) throws Exception {
        this.enableDisableDeployment(name, false);
    }

    private void enableDisableDeployment(String name, boolean enable) throws Exception {
        if (this.isDeploymentEnabled(name) == enable) {
            return;
        }
        Address addr = Address.root().add(SUBSYSTEM_DEPLOYMENT, name);
        ModelNode request = DeploymentJBossASClient.createWriteAttributeRequest(ENABLED, Boolean.toString(enable), addr);
        ModelNode results = this.execute(request);
        if (!DeploymentJBossASClient.isSuccess(results)) {
            throw new FailureException(results);
        }
    }

    public String getDeploymentPath(String name) throws Exception {
        Address addr = Address.root().add(SUBSYSTEM_DEPLOYMENT, name);
        ModelNode op = DeploymentJBossASClient.createReadAttributeRequest(CONTENT, addr);
        ModelNode results = this.execute(op);
        if (DeploymentJBossASClient.isSuccess(results)) {
            ModelNode path;
            try {
                path = ((ModelNode)DeploymentJBossASClient.getResults(results).asList().get(0)).asObject().get(PATH);
            }
            catch (Exception e) {
                throw new Exception("Cannot get path associated with deployment [" + name + "]");
            }
            if (path != null) {
                return path.asString();
            }
            throw new Exception("No path associated with deployment [" + name + "]");
        }
        throw new FailureException(results, "Cannot get the deployment path");
    }
}

