/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jmx;

import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jmx.MBeanResourceComponent;

public class ThreadDataMeasurementComponent
extends MBeanResourceComponent {
    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if ("threadDump".equals(name)) {
            ThreadMXBean threadBean = (ThreadMXBean)this.getEmsBean().getProxy(ThreadMXBean.class);
            long[] threadIds = threadBean.getAllThreadIds();
            ThreadInfo[] threadInfos = threadBean.getThreadInfo(threadIds, Integer.MAX_VALUE);
            OperationResult result = new OperationResult();
            Configuration resultConfig = result.getComplexResults();
            resultConfig.put((Property)new PropertySimple("totalCount", (Object)threadBean.getThreadCount()));
            PropertyList threadList = new PropertyList("threadList");
            resultConfig.put((Property)threadList);
            for (ThreadInfo threadInfo : threadInfos) {
                PropertyMap map = new PropertyMap("thread");
                map.put((Property)new PropertySimple("name", (Object)threadInfo.getThreadName()));
                map.put((Property)new PropertySimple("id", (Object)threadInfo.getThreadId()));
                map.put((Property)new PropertySimple("state", (Object)threadInfo.getThreadState().name()));
                map.put((Property)new PropertySimple("stack", (Object)this.getStringStackTrace(threadInfo.getStackTrace())));
                threadList.add((Property)map);
            }
            return result;
        }
        return super.invokeOperation(name, parameters);
    }

    private String getStringStackTrace(StackTraceElement[] st) {
        StringBuilder buf = new StringBuilder(2000);
        for (StackTraceElement e : st) {
            buf.append(e.getClassName());
            buf.append(".");
            buf.append(e.getMethodName());
            buf.append("(");
            buf.append(e.getFileName());
            buf.append(":");
            buf.append(e.getLineNumber());
            buf.append(")\n");
        }
        if (buf.length() > 2000) {
            return buf.substring(0, 2000);
        }
        return buf.toString();
    }
}

