/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jmx;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rhq.core.domain.configuration.Configuration;

public class ObjectNameQueryUtility {
    private String queryTemplate;
    private Map<String, String> variableProperties = new HashMap<String, String>();
    private Map<String, String> variableValues = new HashMap<String, String>();
    private Set<String> nonVariableProperties = new HashSet<String>();
    private String translatedQuery;

    public ObjectNameQueryUtility(String objectNameQueryTemplate) {
        this.queryTemplate = objectNameQueryTemplate;
        this.buildMatchMap(this.queryTemplate);
    }

    public ObjectNameQueryUtility(String objectNameQueryTemplate, Configuration parentConfiguration) {
        Pattern p = Pattern.compile("\\{([^\\{\\}]*)\\}");
        Matcher m = p.matcher(objectNameQueryTemplate);
        while (m.find()) {
            String objectNameKeyPropVariableName = m.group(1);
            String value = parentConfiguration.getSimple(objectNameKeyPropVariableName).getStringValue();
            objectNameQueryTemplate = objectNameQueryTemplate.replaceAll("\\{" + objectNameKeyPropVariableName + "\\}", value);
        }
        this.queryTemplate = objectNameQueryTemplate;
        this.buildMatchMap(this.queryTemplate);
    }

    public boolean setMatchedKeyValues(Map<String, String> keyProperties) {
        for (String key : keyProperties.keySet()) {
            if (!this.variableProperties.containsKey(key)) continue;
            String realKey = this.variableProperties.get(key);
            String value = keyProperties.get(key);
            this.variableValues.put(realKey, value);
        }
        return keyProperties.keySet().containsAll(this.variableProperties.keySet());
    }

    public String formatMessage(String message) {
        for (String key : this.variableValues.keySet()) {
            message = message.replaceAll("\\{" + key + "\\}", this.variableValues.get(key));
        }
        return message;
    }

    public void resetVariables() {
        this.variableValues.clear();
    }

    public String getQueryTemplate() {
        return this.queryTemplate;
    }

    public Map<String, String> getVariableProperties() {
        return this.variableProperties;
    }

    public Map<String, String> getVariableValues() {
        return this.variableValues;
    }

    public String getTranslatedQuery() {
        return this.translatedQuery;
    }

    private void buildMatchMap(String objectNameQueryTemplate) {
        StringBuilder queryBuilder = new StringBuilder();
        Pattern p = Pattern.compile("^([^:]*\\:)(.*)$");
        Matcher m = p.matcher(objectNameQueryTemplate);
        if (!m.find()) assert (false) : "ObjectName did not match expected regular expression: " + objectNameQueryTemplate;
        queryBuilder.append(m.group(1));
        String keyProps = m.group(2);
        String[] keys = keyProps.split(",");
        boolean firstVar = true;
        boolean onlyVar = true;
        for (String key : keys) {
            Pattern p2 = Pattern.compile("^([^=]*)=\\%(.*)\\%$");
            Matcher m2 = p2.matcher(key);
            if (m2.find()) {
                this.variableProperties.put(m2.group(1), m2.group(2));
                continue;
            }
            Pattern p3 = Pattern.compile("^([^=]*)=(.*)$");
            Matcher m3 = p3.matcher(key);
            if (m3.find()) {
                this.nonVariableProperties.add(m3.group(1));
            }
            onlyVar = false;
            if (firstVar) {
                firstVar = false;
            } else {
                queryBuilder.append(",");
            }
            queryBuilder.append(key);
        }
        if (this.variableProperties.size() > 0) {
            if (!onlyVar) {
                queryBuilder.append(",");
            }
            queryBuilder.append("*");
        }
        this.translatedQuery = queryBuilder.toString();
    }

    public boolean isContainsExtraKeyProperties(Set<String> strings) {
        for (String key : strings) {
            if (this.nonVariableProperties.contains(key) || this.variableProperties.containsKey(key)) continue;
            return true;
        }
        return false;
    }
}

