/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jmx.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import org.mc4j.ems.connection.ConnectionFactory;
import org.mc4j.ems.connection.local.LocalVMFinder;
import org.mc4j.ems.connection.local.LocalVirtualMachine;
import org.mc4j.ems.connection.settings.ConnectionSettings;
import org.mc4j.ems.connection.support.ConnectionProvider;
import org.mc4j.ems.connection.support.metadata.ConnectionTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.J2SE5ConnectionTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.LocalVMTypeDescriptor;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.jmx.util.JvmUtility;

public class ConnectionProviderFactory {
    public static ConnectionProvider createConnectionProvider(Configuration pluginConfig, ProcessInfo process, File tempDir) throws Exception {
        ConnectionTypeDescriptor connectionTypeDescriptor;
        Class<?> connectionTypeDescriptorClass;
        String connectionTypeDescriptorClassName = pluginConfig.getSimple("type").getStringValue();
        if (connectionTypeDescriptorClassName.equals("LocalVMTypeDescriptor")) {
            connectionTypeDescriptorClassName = LocalVMTypeDescriptor.class.getName();
        }
        try {
            connectionTypeDescriptorClass = Class.forName(connectionTypeDescriptorClassName);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidPluginConfigurationException("Invalid connection type - class [" + connectionTypeDescriptorClassName + "] not found.");
        }
        if (!ConnectionTypeDescriptor.class.isAssignableFrom(connectionTypeDescriptorClass)) {
            throw new InvalidPluginConfigurationException("Invalid connection type - class [" + connectionTypeDescriptorClassName + "] does not implement the " + ConnectionTypeDescriptor.class.getName() + " interface.");
        }
        try {
            connectionTypeDescriptor = (ConnectionTypeDescriptor)connectionTypeDescriptorClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate connection type descriptor of type [" + connectionTypeDescriptorClassName + "].", e);
        }
        ConnectionSettings settings = new ConnectionSettings();
        settings.initializeConnectionType(connectionTypeDescriptor);
        String principal = pluginConfig.getSimpleValue("principal", null);
        settings.setPrincipal(principal);
        String credentials = pluginConfig.getSimpleValue("credentials", null);
        settings.setCredentials(credentials);
        if (connectionTypeDescriptor instanceof LocalVMTypeDescriptor) {
            String commandLine = pluginConfig.getSimpleValue("commandLine", null);
            if (commandLine == null) {
                throw new InvalidPluginConfigurationException("A command line is required for the " + connectionTypeDescriptorClassName + " connection type.");
            }
            Map vms = LocalVMFinder.getManageableVirtualMachines();
            LocalVirtualMachine targetVm = null;
            if (vms != null) {
                for (LocalVirtualMachine vm : vms.values()) {
                    if (!vm.getCommandLine().equals(commandLine)) continue;
                    targetVm = vm;
                    break;
                }
            }
            if (targetVm == null) {
                throw new Exception("JVM with command line [" + commandLine + "] not found.");
            }
            String vmId = String.valueOf(targetVm.getVmid());
            settings.setServerUrl(vmId);
        } else if (connectionTypeDescriptor instanceof J2SE5ConnectionTypeDescriptor) {
            String jmxConnectorAddress = ConnectionProviderFactory.getJmxConnectorAddress(pluginConfig, process);
            settings.setServerUrl(jmxConnectorAddress);
        } else {
            String connectorAddress = pluginConfig.getSimpleValue("connectorAddress", null);
            if (connectorAddress == null) {
                throw new InvalidPluginConfigurationException("A connector address is required for the " + connectionTypeDescriptorClassName + " connection type.");
            }
            settings.setServerUrl(connectorAddress);
            String installURI = pluginConfig.getSimpleValue("installURI", null);
            settings.setLibraryURI(installURI);
        }
        ConnectionProviderFactory.addAdditionalJarsToConnectionSettings(settings, pluginConfig);
        return ConnectionProviderFactory.createConnectionProvider(settings, tempDir);
    }

    private static ConnectionProvider createConnectionProvider(ConnectionSettings settings, File tempDir) {
        settings.getControlProperties().setProperty("mc4j.ems.CopyJarsToTemp", String.valueOf(Boolean.TRUE));
        settings.getControlProperties().setProperty("mc4j.ems.JarTempDir", tempDir.getAbsolutePath());
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.discoverServerClasses(settings);
        return connectionFactory.getConnectionProvider(settings);
    }

    private static void addAdditionalJarsToConnectionSettings(ConnectionSettings settings, Configuration pluginConfig) {
        List<File> additionalEntries = ConnectionProviderFactory.getAdditionalJarsFromConfig(pluginConfig);
        if (additionalEntries == null || additionalEntries.size() == 0) {
            return;
        }
        ArrayList<File> settingsEntries = settings.getClassPathEntries();
        if (settingsEntries == null) {
            settingsEntries = new ArrayList<File>();
        }
        settingsEntries.addAll(additionalEntries);
        settings.setClassPathEntries(settingsEntries);
    }

    private static String getJmxConnectorAddress(Configuration pluginConfig, ProcessInfo process) throws Exception {
        String connectorAddress = pluginConfig.getSimpleValue("connectorAddress", null);
        if (connectorAddress == null) {
            if (process == null) {
                throw new Exception("Could not find java process for JVM.");
            }
            JMXServiceURL jmxServiceURL = JvmUtility.extractJMXServiceURL(process);
            if (jmxServiceURL == null) {
                throw new Exception("Could not obtain JMX service URL via Attach API for JVM [" + process + "].");
            }
            connectorAddress = jmxServiceURL.toString();
        }
        return connectorAddress;
    }

    public static List<File> getAdditionalJarsFromConfig(Configuration pluginConfiguration) {
        ArrayList<File> jarFiles = new ArrayList<File>();
        PropertySimple prop = pluginConfiguration.getSimple("additionalClassPathEntries");
        if (prop == null || prop.getStringValue() == null || prop.getStringValue().trim().length() == 0) {
            return jarFiles;
        }
        String[] paths = prop.getStringValue().trim().split(",");
        if (paths == null || paths.length == 0) {
            return jarFiles;
        }
        for (String path : paths) {
            if ((path = path.trim()).length() <= 0) continue;
            if (path.endsWith("*.jar")) {
                File dir = new File(path = path.substring(0, path.length() - 5));
                final class JarFilenameFilter
                implements FilenameFilter {
                    JarFilenameFilter() {
                    }

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jar");
                    }
                }
                File[] jars = dir.listFiles(new JarFilenameFilter());
                if (jars == null || jars.length <= 0) continue;
                jarFiles.addAll(Arrays.asList(jars));
                continue;
            }
            File pathFile = new File(path);
            jarFiles.add(pathFile);
        }
        return jarFiles;
    }
}

