/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jmx.util;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.jmx.MBeanResourceComponent;

public class JvmUtility {
    private static final Log LOG = LogFactory.getLog(MBeanResourceComponent.class);
    private static final String AGENT_PROP_JMXREMOTE_LOCAL_CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";
    private static boolean attachApiAvailable;

    public static JMXServiceURL extractJMXServiceURL(ProcessInfo process) {
        JMXServiceURL url;
        if (!attachApiAvailable) {
            LOG.debug((Object)"Returning null, since the Attach API is not available...");
            return null;
        }
        try {
            VirtualMachine vm = JvmUtility.attachToVirtualMachine(process);
            if (vm == null) {
                return null;
            }
            String jmxConnectorAddress = JvmUtility.getJmxConnectorAddress(vm);
            try {
                vm.detach();
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to detach from JVM [" + vm + "]."), (Throwable)e);
            }
            url = new JMXServiceURL(jmxConnectorAddress);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to extract JMX service URL for process with PID [" + process.getPid() + "].", e);
        }
        LOG.debug((Object)("JMX service URL for java process with PID [" + process.getPid() + "]: " + url));
        return url;
    }

    private static VirtualMachine attachToVirtualMachine(ProcessInfo process) throws AttachNotSupportedException, IOException {
        VirtualMachine vm = null;
        List<VirtualMachineDescriptor> vmDescriptors = VirtualMachine.list();
        for (VirtualMachineDescriptor vmDescriptor : vmDescriptors) {
            String agentUserName;
            if (Long.valueOf(vmDescriptor.id()).longValue() != process.getPid()) continue;
            String vmUserName = process.getCredentialsName().getUser();
            if (vmUserName.equals(agentUserName = System.getProperty("user.name"))) {
                LOG.debug((Object)("Attaching to JVM for java process with PID [" + process.getPid() + "]..."));
                vm = VirtualMachine.attach(vmDescriptor);
                LOG.debug((Object)("Attached to JVM [" + vm + "]."));
                break;
            }
            LOG.debug((Object)("Cannot attach to JVM for java process with PID [" + process.getPid() + "], because it is running as a different user (" + vmUserName + ") than the user the Agent is running as (" + agentUserName + ")."));
            break;
        }
        return vm;
    }

    private static String getJmxConnectorAddress(VirtualMachine vm) throws IOException {
        String jmxConnectorAddress = vm.getAgentProperties().getProperty(AGENT_PROP_JMXREMOTE_LOCAL_CONNECTOR_ADDRESS);
        LOG.debug((Object)("Connector address for JVM [" + vm + "] is [" + jmxConnectorAddress + "]."));
        if (jmxConnectorAddress == null) {
            String jreDir = vm.getSystemProperties().getProperty("java.home");
            File jmxAgentJarFile = new File(jreDir, "lib/management-agent.jar");
            String jmxAgentJar = jmxAgentJarFile.getCanonicalPath();
            try {
                vm.loadAgent(jmxAgentJar);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load JVM agent from [" + jmxAgentJar + "].", e);
            }
            LOG.debug((Object)"JMX agent started - getting the connector address...");
            jmxConnectorAddress = vm.getAgentProperties().getProperty(AGENT_PROP_JMXREMOTE_LOCAL_CONNECTOR_ADDRESS);
            if (jmxConnectorAddress == null) {
                throw new RuntimeException("Failed to determine JMX connector address.");
            }
        }
        return jmxConnectorAddress;
    }

    private JvmUtility() {
    }

    static {
        try {
            Class.forName("com.sun.tools.attach.VirtualMachine");
            attachApiAvailable = true;
        }
        catch (ClassNotFoundException e) {
            LOG.warn((Object)"JDK tools.jar not found on system classpath - cannot discover JVMs using Sun JVM Attach API; to fix this, run the RHQ Agent on a JDK, rather than a JRE.");
        }
    }
}

