/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.mysql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.ProcessInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySqlDiscoveryComponent
implements ResourceDiscoveryComponent,
ManualAddFacet {
    private static final Log log = LogFactory.getLog(MySqlDiscoveryComponent.class);
    public static final String DRIVER_CONFIGURATION_PROPERTY = "driverClass";
    public static final String HOST_CONFIGURATION_PROPERTY = "host";
    public static final String PORT_CONFIGURATION_PROPERTY = "port";
    public static final String DB_CONFIGURATION_PROPERTY = "db";
    public static final String PRINCIPAL_CONFIGURATION_PROPERTY = "principal";
    public static final String CREDENTIALS_CONFIGURATION_PROPERTY = "credentials";
    private static final String DEFAULT_RESOURCE_DESCRIPTION = "Mysql relational database server";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext context) {
        LinkedHashSet<DiscoveredResourceDetails> servers = new LinkedHashSet<DiscoveredResourceDetails>();
        List autoDiscoveryResults = context.getAutoDiscoveredProcesses();
        for (ProcessScanResult result : autoDiscoveryResults) {
            log.info((Object)("Discovered a mysql process: " + result));
            ProcessInfo procInfo = result.getProcessInfo();
        }
        return servers;
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfiguration, ResourceDiscoveryContext resourceDiscoveryContext) throws InvalidPluginConfigurationException {
        ProcessInfo processInfo = null;
        DiscoveredResourceDetails resourceDetails = MySqlDiscoveryComponent.createResourceDetails(resourceDiscoveryContext, pluginConfiguration, processInfo);
        return resourceDetails;
    }

    protected static DiscoveredResourceDetails createResourceDetails(ResourceDiscoveryContext discoveryContext, Configuration pluginConfiguration, ProcessInfo processInfo) {
        String key = MySqlDiscoveryComponent.buildUrl(pluginConfiguration);
        String db = pluginConfiguration.getSimple(DB_CONFIGURATION_PROPERTY).getStringValue();
        String name = "MySql [" + db + "]";
        String version = MySqlDiscoveryComponent.getVersion(pluginConfiguration);
        return new DiscoveredResourceDetails(discoveryContext.getResourceType(), key, name, version, DEFAULT_RESOURCE_DESCRIPTION, pluginConfiguration, processInfo);
    }

    protected static String buildUrl(Configuration config) {
        String host = config.getSimple(HOST_CONFIGURATION_PROPERTY).getStringValue();
        String port = config.getSimple(PORT_CONFIGURATION_PROPERTY).getStringValue();
        String user = config.getSimple(PRINCIPAL_CONFIGURATION_PROPERTY).getStringValue();
        String pass = config.getSimple(CREDENTIALS_CONFIGURATION_PROPERTY).getStringValue();
        String url = "jdbc:mysql://" + host + "?user=" + user + "&password=" + pass;
        return url;
    }

    protected static String getVersion(Configuration config) {
        String version = null;
        try {
            Connection conn = MySqlDiscoveryComponent.buildConnection(config);
            version = conn.getMetaData().getDatabaseProductVersion();
        }
        catch (SQLException e) {
            log.info((Object)"Exception detecting mysql instance version", (Throwable)e);
        }
        return version;
    }

    public static Connection buildConnection(Configuration configuration) throws SQLException {
        String driverClass = configuration.getSimple(DRIVER_CONFIGURATION_PROPERTY).getStringValue();
        try {
            Class.forName(driverClass);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidPluginConfigurationException("Specified JDBC driver class (" + driverClass + ") not found.");
        }
        String url = MySqlDiscoveryComponent.buildUrl(configuration);
        return DriverManager.getConnection(url);
    }
}

