/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.mysql;

import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.pluginapi.plugin.PluginContext;
import org.rhq.core.pluginapi.plugin.PluginLifecycleListener;
import org.rhq.core.util.exception.ThrowableUtil;

public class MySqlPluginLifecycleListener
implements PluginLifecycleListener {
    private final Log log = LogFactory.getLog(MySqlPluginLifecycleListener.class);

    public void initialize(PluginContext context) throws Exception {
    }

    public void shutdown() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            try {
                Driver driver = drivers.nextElement();
                DriverManager.deregisterDriver(driver);
                this.log.debug((Object)("Deregistered JDBC driver: " + driver.getClass()));
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to deregister JDBC drivers - memory might leak" + ThrowableUtil.getAllMessages((Throwable)e)));
            }
        }
        this.log.debug((Object)(this.getClass().getSimpleName() + " completed shutdown."));
    }
}

