/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.mysql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.availability.AvailabilityFacet;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.database.ConnectionPoolingSupport;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.database.DatabasePluginUtil;
import org.rhq.plugins.database.PooledConnectionProvider;
import org.rhq.plugins.mysql.MySqlComponent;

public class MySqlDatabaseComponent
implements DatabaseComponent,
ConnectionPoolingSupport,
AvailabilityFacet,
OperationFacet {
    private static final Log LOG = LogFactory.getLog(MySqlDatabaseComponent.class);
    private ResourceContext resourceContext;
    private MySqlComponent parent;
    private String databaseName;

    public Connection getConnection() {
        return this.parent.getConnection();
    }

    public void removeConnection() {
        this.parent.removeConnection();
    }

    public boolean supportsConnectionPooling() {
        return true;
    }

    public PooledConnectionProvider getPooledConnectionProvider() {
        return this.parent.getPooledConnectionProvider();
    }

    public void start(ResourceContext rc) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = rc;
        this.databaseName = rc.getResourceKey();
        this.parent = (MySqlComponent)this.resourceContext.getParentResourceComponent();
    }

    public String getName() {
        return this.databaseName;
    }

    public void stop() {
        this.resourceContext = null;
        this.databaseName = null;
        this.parent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvailabilityType getAvailability() {
        ResultSet resultSet;
        Statement statement;
        Connection jdbcConnection;
        AvailabilityType result;
        block5: {
            result = AvailabilityType.DOWN;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Availability check for " + this.databaseName));
            }
            jdbcConnection = null;
            statement = null;
            resultSet = null;
            try {
                jdbcConnection = this.getPooledConnectionProvider().getPooledConnection();
                statement = jdbcConnection.createStatement();
                resultSet = statement.executeQuery("SHOW DATABASES LIKE '" + this.databaseName + "'");
                if (!resultSet.next() || !resultSet.getString(1).equalsIgnoreCase(this.databaseName)) break block5;
                result = AvailabilityType.UP;
            }
            catch (SQLException e) {
                block6: {
                    try {
                        if (!LOG.isDebugEnabled()) break block6;
                        LOG.debug((Object)"Got Exception when determining database availability", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        DatabasePluginUtil.safeClose((Connection)jdbcConnection, statement, resultSet);
                        throw throwable;
                    }
                }
                DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, resultSet);
            }
        }
        DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, (ResultSet)resultSet);
        return result;
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if ("invokeSql".equals(name)) {
            return this.invokeSql(parameters);
        }
        throw new UnsupportedOperationException("Operation [" + name + "] is not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult invokeSql(Configuration parameters) throws SQLException {
        OperationResult operationResult;
        Connection jdbcConnection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            jdbcConnection = this.getPooledConnectionProvider().getPooledConnection();
            statement = this.getConnection().createStatement();
            String sql = parameters.getSimple("sql").getStringValue();
            OperationResult result = new OperationResult();
            if (parameters.getSimple("type").getStringValue().equals("update")) {
                int updateCount = statement.executeUpdate(sql);
                result.getComplexResults().put((Property)new PropertySimple("result", (Object)("Query updated " + updateCount + " rows")));
            } else {
                int i;
                resultSet = statement.executeQuery(parameters.getSimple("sql").getStringValue());
                ResultSetMetaData md = resultSet.getMetaData();
                StringBuilder buf = new StringBuilder();
                int rowCount = 0;
                buf.append("<table>");
                buf.append("<th>");
                for (i = 1; i <= md.getColumnCount(); ++i) {
                    buf.append("<td>");
                    buf.append(md.getColumnName(i) + " (" + md.getColumnTypeName(i) + ")");
                    buf.append("</td>");
                }
                buf.append("</th>");
                while (resultSet.next()) {
                    ++rowCount;
                    buf.append("<tr>");
                    for (i = 1; i <= md.getColumnCount(); ++i) {
                        buf.append("<td>");
                        buf.append(resultSet.getString(i));
                        buf.append("</td>");
                    }
                    buf.append("</tr>");
                }
                buf.append("</table>");
                result.getComplexResults().put((Property)new PropertySimple("result", (Object)("Query returned " + rowCount + " rows")));
                result.getComplexResults().put((Property)new PropertySimple("contents", (Object)buf.toString()));
            }
            operationResult = result;
        }
        catch (Throwable throwable) {
            DatabasePluginUtil.safeClose((Connection)jdbcConnection, statement, resultSet);
            throw throwable;
        }
        DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, (ResultSet)resultSet);
        return operationResult;
    }
}

