/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.mysql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.plugins.database.ConnectionPoolingSupport;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.database.DatabasePluginUtil;
import org.rhq.plugins.database.PooledConnectionProvider;
import org.rhq.plugins.mysql.MySqlDatabaseComponent;

public class MySqlTableComponent
implements DatabaseComponent,
ConnectionPoolingSupport,
MeasurementFacet {
    private static final Log LOG = LogFactory.getLog(MySqlTableComponent.class);
    private String tableName;
    private MySqlDatabaseComponent parent;
    private String databaseName;

    public Connection getConnection() {
        return this.parent.getConnection();
    }

    public void removeConnection() {
        this.parent.removeConnection();
    }

    public boolean supportsConnectionPooling() {
        return true;
    }

    public PooledConnectionProvider getPooledConnectionProvider() {
        return this.parent.getPooledConnectionProvider();
    }

    public void start(ResourceContext rc) throws InvalidPluginConfigurationException, Exception {
        this.tableName = rc.getResourceKey();
        this.parent = (MySqlDatabaseComponent)rc.getParentResourceComponent();
        this.databaseName = this.parent.getName();
    }

    public void stop() {
        this.tableName = null;
        this.parent = null;
        this.databaseName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public AvailabilityType getAvailability() {
        ResultSet resultSet;
        Statement statement;
        Connection jdbcConnection;
        block4: {
            AvailabilityType availabilityType;
            jdbcConnection = null;
            statement = null;
            resultSet = null;
            try {
                jdbcConnection = this.getPooledConnectionProvider().getPooledConnection();
                statement = jdbcConnection.createStatement();
                resultSet = statement.executeQuery("show tables from " + this.databaseName + " like '" + this.tableName + "'");
                if (!resultSet.first()) break block4;
                availabilityType = AvailabilityType.UP;
            }
            catch (SQLException se) {
                DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, resultSet);
                catch (Throwable throwable) {
                    DatabasePluginUtil.safeClose((Connection)jdbcConnection, statement, resultSet);
                    throw throwable;
                }
            }
            DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, (ResultSet)resultSet);
            return availabilityType;
        }
        DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, (ResultSet)resultSet);
        return AvailabilityType.DOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getValues(MeasurementReport mr, Set<MeasurementScheduleRequest> set) throws Exception {
        ResultSet resultSet;
        Statement statement;
        Connection jdbcConnection;
        block10: {
            jdbcConnection = null;
            statement = null;
            resultSet = null;
            try {
                jdbcConnection = this.getPooledConnectionProvider().getPooledConnection();
                statement = jdbcConnection.createStatement();
                resultSet = statement.executeQuery("show table status from " + this.databaseName + " like '" + this.tableName + "'");
                if (!resultSet.next()) break block10;
                for (MeasurementScheduleRequest request : set) {
                    String value = resultSet.getString(request.getName());
                    if (value == null) {
                        value = "0";
                    }
                    switch (request.getDataType()) {
                        case MEASUREMENT: {
                            mr.addData(new MeasurementDataNumeric(request, Double.valueOf(value)));
                            break;
                        }
                        case TRAIT: {
                            mr.addData(new MeasurementDataTrait(request, value));
                            break;
                        }
                    }
                }
            }
            catch (Exception se) {
                block11: {
                    try {
                        if (!LOG.isDebugEnabled()) break block11;
                        LOG.debug((Object)"Unable to measure table statistics", (Throwable)se);
                    }
                    catch (Throwable throwable) {
                        DatabasePluginUtil.safeClose((Connection)jdbcConnection, statement, resultSet);
                        throw throwable;
                    }
                }
                DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, resultSet);
            }
        }
        DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, (ResultSet)resultSet);
    }
}

