/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.mysql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.database.DatabasePluginUtil;
import org.rhq.plugins.mysql.MySqlComponent;

public class MySqlUserDiscoveryComponent
implements ResourceDiscoveryComponent {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Set discoverResources(ResourceDiscoveryContext rdc) throws InvalidPluginConfigurationException, Exception {
        HashSet<DiscoveredResourceDetails> set = new HashSet<DiscoveredResourceDetails>();
        MySqlComponent parent = (MySqlComponent)rdc.getParentResourceComponent();
        Connection jdbcConnection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            jdbcConnection = parent.getPooledConnectionProvider().getPooledConnection();
            statement = jdbcConnection.createStatement();
            resultSet = statement.executeQuery("select User,Host from mysql.user");
            while (resultSet.next()) {
                String user = resultSet.getString(1);
                String host = resultSet.getString(2);
                String userName = user + "@" + host;
                Configuration config = new Configuration();
                config.put((Property)new PropertySimple("userName", (Object)user));
                config.put((Property)new PropertySimple("host", (Object)host));
                DiscoveredResourceDetails discoveredUser = new DiscoveredResourceDetails(rdc.getResourceType(), userName, userName, null, "A MySql User", config, null);
                set.add(discoveredUser);
            }
        }
        catch (Exception e) {
            DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, resultSet);
            catch (Throwable throwable) {
                DatabasePluginUtil.safeClose((Connection)jdbcConnection, statement, resultSet);
                throw throwable;
            }
        }
        DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, (ResultSet)resultSet);
        return set;
    }
}

