/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.mysql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.availability.AvailabilityFacet;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.database.DatabaseQueryUtility;
import org.rhq.plugins.mysql.MySqlComponent;

public class MySqlDatabaseComponent
implements DatabaseComponent,
AvailabilityFacet,
OperationFacet {
    private ResourceContext resourceContext;
    private MySqlComponent parent;
    private String databaseName;
    private static Log log = LogFactory.getLog(MySqlDatabaseComponent.class);

    public Connection getConnection() {
        return this.parent.getConnection();
    }

    public void removeConnection() {
        this.parent.removeConnection();
    }

    public void start(ResourceContext rc) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = rc;
        this.databaseName = rc.getResourceKey();
        this.parent = (MySqlComponent)this.resourceContext.getParentResourceComponent();
    }

    public String getName() {
        return this.databaseName;
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvailabilityType getAvailability() {
        Connection conn;
        AvailabilityType result = AvailabilityType.DOWN;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Availability check for " + this.databaseName));
        }
        if ((conn = this.getConnection()) != null) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = conn.createStatement();
                resultSet = statement.executeQuery("SHOW DATABASES LIKE '" + this.databaseName + "'");
                if (resultSet.next() && resultSet.getString(1).equalsIgnoreCase(this.databaseName)) {
                    result = AvailabilityType.UP;
                }
                DatabaseQueryUtility.close((Statement)statement, (ResultSet)resultSet);
            }
            catch (SQLException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Got Exception when determining database availability", (Throwable)e);
                }
            }
            finally {
                DatabaseQueryUtility.close((Statement)statement, resultSet);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if ("invokeSql".equals(name)) {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.getConnection().createStatement();
                String sql = parameters.getSimple("sql").getStringValue();
                OperationResult result = new OperationResult();
                if (parameters.getSimple("type").getStringValue().equals("update")) {
                    int updateCount = stmt.executeUpdate(sql);
                    result.getComplexResults().put((Property)new PropertySimple("result", (Object)("Query updated " + updateCount + " rows")));
                } else {
                    int i;
                    rs = stmt.executeQuery(parameters.getSimple("sql").getStringValue());
                    ResultSetMetaData md = rs.getMetaData();
                    StringBuilder buf = new StringBuilder();
                    int rowCount = 0;
                    buf.append("<table>");
                    buf.append("<th>");
                    for (i = 1; i <= md.getColumnCount(); ++i) {
                        buf.append("<td>");
                        buf.append(md.getColumnName(i) + " (" + md.getColumnTypeName(i) + ")");
                        buf.append("</td>");
                    }
                    buf.append("</th>");
                    while (rs.next()) {
                        ++rowCount;
                        buf.append("<tr>");
                        for (i = 1; i <= md.getColumnCount(); ++i) {
                            buf.append("<td>");
                            buf.append(rs.getString(i));
                            buf.append("</td>");
                        }
                        buf.append("</tr>");
                    }
                    buf.append("</table>");
                    result.getComplexResults().put((Property)new PropertySimple("result", (Object)("Query returned " + rowCount + " rows")));
                    result.getComplexResults().put((Property)new PropertySimple("contents", (Object)buf.toString()));
                }
                OperationResult operationResult = result;
                return operationResult;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        throw new UnsupportedOperationException("Operation [" + name + "] is not supported yet.");
    }
}

