/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.mysql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.database.DatabaseQueryUtility;
import org.rhq.plugins.mysql.MySqlDatabaseComponent;

public class MySqlTableComponent
implements DatabaseComponent,
MeasurementFacet {
    private String tableName;
    private MySqlDatabaseComponent parent;
    private String databaseName;
    private Log log = LogFactory.getLog(this.getClass());

    public Connection getConnection() {
        return this.parent.getConnection();
    }

    public void removeConnection() {
        this.parent.removeConnection();
    }

    public void start(ResourceContext rc) throws InvalidPluginConfigurationException, Exception {
        this.tableName = rc.getResourceKey();
        this.parent = (MySqlDatabaseComponent)rc.getParentResourceComponent();
        this.databaseName = this.parent.getName();
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public AvailabilityType getAvailability() {
        AvailabilityType result = AvailabilityType.DOWN;
        Connection conn = this.parent.getConnection();
        if (conn != null) {
            ResultSet rs;
            Statement stmt;
            block5: {
                stmt = null;
                rs = null;
                try {
                    stmt = conn.createStatement();
                    rs = stmt.executeQuery("show tables from " + this.databaseName + " like '" + this.tableName + "'");
                    if (!rs.first()) break block5;
                    result = AvailabilityType.UP;
                }
                catch (SQLException se) {
                    DatabaseQueryUtility.close((Statement)stmt, rs);
                    catch (Throwable throwable) {
                        DatabaseQueryUtility.close((Statement)stmt, rs);
                        throw throwable;
                    }
                }
            }
            DatabaseQueryUtility.close((Statement)stmt, (ResultSet)rs);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getValues(MeasurementReport mr, Set<MeasurementScheduleRequest> set) throws Exception {
        Connection conn = this.parent.getConnection();
        if (conn != null) {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = conn.createStatement();
                rs = stmt.executeQuery("show table status from " + this.databaseName + " like '" + this.tableName + "'");
                if (rs.next()) {
                    for (MeasurementScheduleRequest request : set) {
                        String value = rs.getString(request.getName());
                        if (value == null) {
                            value = "0";
                        }
                        switch (request.getDataType()) {
                            case MEASUREMENT: {
                                mr.addData(new MeasurementDataNumeric(request, Double.valueOf(value)));
                                break;
                            }
                            case TRAIT: {
                                mr.addData(new MeasurementDataTrait(request, value));
                                break;
                            }
                        }
                    }
                }
                DatabaseQueryUtility.close((Statement)stmt, (ResultSet)rs);
            }
            catch (Exception se) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"Unable to measure table statistics", (Throwable)se);
                }
            }
            finally {
                DatabaseQueryUtility.close((Statement)stmt, rs);
            }
        }
    }
}

