/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.plugins.database.AbstractDatabaseComponent;
import org.rhq.plugins.database.DatabasePluginUtil;

public class OracleUserComponent
extends AbstractDatabaseComponent
implements MeasurementFacet {
    private static final Log LOG = LogFactory.getLog(OracleUserComponent.class);
    private static final String SQL_USER = "SELECT COUNT(*) FROM DBA_USERS WHERE username = ?";
    private static final String SESSIONS = "SELECT SUM(DECODE(Status, 'ACTIVE', 1, 0)) active, COUNT(1) connections FROM V$SESSION where username = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvailabilityType getAvailability() {
        ResultSet resultSet;
        PreparedStatement statement;
        Connection jdbcConnection;
        block8: {
            AvailabilityType availabilityType;
            jdbcConnection = null;
            statement = null;
            resultSet = null;
            try {
                jdbcConnection = DatabasePluginUtil.getConnectionFromComponent((ResourceComponent)this);
                statement = jdbcConnection.prepareStatement(SQL_USER);
                statement.setString(1, this.resourceContext.getResourceKey());
                resultSet = statement.executeQuery();
                if (!resultSet.next() || resultSet.getInt(1) != 1) break block8;
                availabilityType = AvailabilityType.UP;
            }
            catch (SQLException e) {
                try {
                    LOG.debug((Object)"unable to query", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DatabasePluginUtil.safeClose(null, statement, resultSet);
                    if (this.supportsConnectionPooling()) {
                        DatabasePluginUtil.safeClose((Connection)jdbcConnection);
                    }
                    throw throwable;
                }
                DatabasePluginUtil.safeClose(null, (Statement)statement, resultSet);
                if (this.supportsConnectionPooling()) {
                    DatabasePluginUtil.safeClose((Connection)jdbcConnection);
                }
            }
            DatabasePluginUtil.safeClose(null, (Statement)statement, (ResultSet)resultSet);
            if (this.supportsConnectionPooling()) {
                DatabasePluginUtil.safeClose((Connection)jdbcConnection);
            }
            return availabilityType;
        }
        DatabasePluginUtil.safeClose(null, (Statement)statement, (ResultSet)resultSet);
        if (this.supportsConnectionPooling()) {
            DatabasePluginUtil.safeClose((Connection)jdbcConnection);
        }
        return AvailabilityType.DOWN;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        Map values = DatabasePluginUtil.getNumericQueryValues((ResourceComponent)this, (String)SESSIONS, (Object[])new Object[]{this.resourceContext.getResourceKey()});
        for (MeasurementScheduleRequest request : metrics) {
            Double d = (Double)values.get(request.getName().toUpperCase(Locale.US));
            if (d == null) continue;
            report.addData(new MeasurementDataNumeric(request, d));
        }
    }
}

