/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.perftest;

import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.content.InstalledPackage;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.event.EventPoller;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.plugins.perftest.ScenarioManager;
import org.rhq.plugins.perftest.event.PerfTestEventPoller;
import org.rhq.plugins.perftest.measurement.MeasurementFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class PerfTestComponent
implements ResourceComponent,
MeasurementFacet,
ContentFacet,
ConfigurationFacet {
    private ResourceContext resourceContext;
    private EventPoller eventPoller;

    public void start(ResourceContext context) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = context;
        this.startEventPollers();
    }

    public void stop() {
        this.stopEventPollers();
    }

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        String resourceTypeName = this.resourceContext.getResourceType().getName();
        ScenarioManager scenarioManager = ScenarioManager.getInstance();
        MeasurementFactory measurementFactory = scenarioManager.getMeasurementFactory(resourceTypeName);
        for (MeasurementScheduleRequest metric : metrics) {
            MeasurementDataNumeric measurementData = (MeasurementDataNumeric)measurementFactory.nextValue(metric);
            if (measurementData == null) continue;
            report.addData(measurementData);
        }
    }

    public void installPackages(Set<InstalledPackage> packages, ContentServices contentServices) {
    }

    public void removePackages(Set<InstalledPackage> packages) {
    }

    public InputStream retrievePackageBits(InstalledPackage pkg) {
        return null;
    }

    public List<DeployPackageStep> generateInstallationSteps(ResourcePackageDetails packageDetails) {
        return null;
    }

    public DeployPackagesResponse deployPackages(Set<ResourcePackageDetails> packages, ContentServices contentServices) {
        return null;
    }

    public RemovePackagesResponse removePackages(Set<ResourcePackageDetails> packages) {
        return null;
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType type) {
        return null;
    }

    public InputStream retrievePackageBits(ResourcePackageDetails packageDetails) {
        return null;
    }

    private void startEventPollers() {
        String pollingIntervalString;
        if (this.resourceContext.getEventContext() != null && (pollingIntervalString = System.getProperty("on.perftest.events.polling-interval")) != null) {
            int pollingInterval;
            try {
                pollingInterval = Integer.parseInt(pollingIntervalString);
            }
            catch (Exception e) {
                pollingInterval = 60;
            }
            this.eventPoller = new PerfTestEventPoller(this.resourceContext);
            this.resourceContext.getEventContext().registerEventPoller(this.eventPoller, pollingInterval);
        }
    }

    private void stopEventPollers() {
        if (this.resourceContext.getEventContext() != null && this.eventPoller != null) {
            this.resourceContext.getEventContext().unregisterEventPoller(this.eventPoller.getEventType());
        }
    }

    public Configuration loadResourceConfiguration() throws Exception {
        try {
            ConfigurationDefinition def = this.resourceContext.getResourceType().getResourceConfigurationDefinition();
            if (def != null) {
                return def.getDefaultTemplate().createConfiguration();
            }
            return new Configuration();
        }
        catch (Exception e) {
            return new Configuration();
        }
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
    }
}

