/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.perftest.content;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.plugins.perftest.content.ContentFactory;
import org.rhq.plugins.perftest.scenario.SimpleContentGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleContentFactory
implements ContentFactory {
    private SimpleContentGenerator generator;
    private final Log log = LogFactory.getLog(this.getClass());

    public SimpleContentFactory(SimpleContentGenerator generator) {
        this.generator = generator;
    }

    @Override
    public Set<ResourcePackageDetails> discoverContent(PackageType type) {
        int numPackages = this.getNumberOfPackages();
        HashSet<ResourcePackageDetails> details = new HashSet<ResourcePackageDetails>(numPackages);
        for (int ii = 0; ii < numPackages; ++ii) {
            String name;
            String key = name = type.getName() + "-" + ii;
            PackageDetailsKey detailsKey = new PackageDetailsKey(name, "1", type.getName(), "noarch");
            ResourcePackageDetails oneDetail = new ResourcePackageDetails(detailsKey);
            details.add(oneDetail);
        }
        return details;
    }

    private int getNumberOfPackages() {
        String propertyName = this.generator.getProperty();
        if (propertyName != null) {
            String propertyString = System.getProperty(propertyName);
            if (propertyString != null) {
                return Integer.parseInt(propertyString);
            }
            this.log.warn((Object)("Property was specified but no value was set. Property: " + propertyName));
        }
        return this.generator.getNumberOfPackages();
    }
}

