/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.perftest.event;

import java.util.HashSet;
import java.util.Set;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.pluginapi.event.EventPoller;
import org.rhq.core.pluginapi.inventory.ResourceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerfTestEventPoller
implements EventPoller {
    public static final String PERFTEST_EVENT_TYPE = "PerfTestEventType";
    public static final String SYSPROP_EVENTS_POLLING_INTERVAL = "on.perftest.events.polling-interval";
    public static final String SYSPROP_EVENTS_COUNT = "on.perftest.events.count";
    public static final String SYSPROP_EVENTS_SEVERITY = "on.perftest.events.severity";
    private final ResourceContext resourceContext;

    public PerfTestEventPoller(ResourceContext resourceContext) {
        this.resourceContext = resourceContext;
    }

    public String getEventType() {
        return PERFTEST_EVENT_TYPE;
    }

    public Set<Event> poll() {
        int count = Integer.parseInt(System.getProperty(SYSPROP_EVENTS_COUNT, "1"));
        String severityString = System.getProperty(SYSPROP_EVENTS_SEVERITY, EventSeverity.INFO.name());
        EventSeverity severity = EventSeverity.valueOf((String)severityString);
        HashSet<Event> events = new HashSet<Event>(count);
        for (int i = 0; i < count; ++i) {
            Event event = new Event(PERFTEST_EVENT_TYPE, "source.loc", System.currentTimeMillis(), severity, "event #" + i);
            events.add(event);
        }
        return events;
    }
}

