/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.perftest.configuration;

import java.util.Collection;
import java.util.Map;
import org.rhq.core.domain.configuration.AbstractPropertyMap;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.plugins.perftest.configuration.ConfigurationFactory;

public class SimpleConfigurationFactory
implements ConfigurationFactory {
    public Configuration generateConfiguration(ConfigurationDefinition definition) {
        Collection allDefinitions = definition.getPropertyDefinitions().values();
        Configuration configuration = new Configuration();
        for (PropertyDefinition propertyDefinition : allDefinitions) {
            SimpleConfigurationFactory.generateProperty(propertyDefinition, (AbstractPropertyMap)configuration);
        }
        return configuration;
    }

    private static void generateProperty(PropertyDefinition propertyDefinition, AbstractPropertyMap parentPropertyMap) {
        PropertySimple property;
        if (propertyDefinition instanceof PropertyDefinitionSimple) {
            property = SimpleConfigurationFactory.generatePropertySimple((PropertyDefinitionSimple)propertyDefinition);
        } else if (propertyDefinition instanceof PropertyDefinitionMap) {
            property = SimpleConfigurationFactory.generatePropertyMap((PropertyDefinitionMap)propertyDefinition);
        } else if (propertyDefinition instanceof PropertyDefinitionList) {
            property = new PropertyList(propertyDefinition.getName());
            PropertyDefinitionList propertyDefinitionList = (PropertyDefinitionList)propertyDefinition;
            PropertyDefinition listMemberPropertyDefinition = propertyDefinitionList.getMemberDefinition();
            if (listMemberPropertyDefinition instanceof PropertyDefinitionMap) {
                PropertyDefinitionMap propertyDefinitionMap = (PropertyDefinitionMap)listMemberPropertyDefinition;
                PropertyList propertyList = (PropertyList)property;
                for (int i = 0; i < 10; ++i) {
                    PropertyMap memberProperty = SimpleConfigurationFactory.generatePropertyMap(propertyDefinitionMap);
                    propertyList.add((Property)memberProperty);
                }
            }
        } else {
            throw new IllegalStateException("Unsupported PropertyDefinition subclass: " + propertyDefinition.getClass().getName());
        }
        parentPropertyMap.put((Property)property);
    }

    private static PropertySimple generatePropertySimple(PropertyDefinitionSimple propertyDefinitionSimple) {
        String value = null;
        switch (propertyDefinitionSimple.getType()) {
            case STRING: {
                value = "blah";
                break;
            }
            case LONG_STRING: {
                value = "line 1\nline 2\nline 3\n";
                break;
            }
            case PASSWORD: {
                value = "secret";
                break;
            }
            case BOOLEAN: {
                value = "true";
                break;
            }
            case INTEGER: {
                value = "42";
                break;
            }
            case LONG: {
                value = "55555555555555555555555";
                break;
            }
            case FLOAT: {
                value = "3.14";
                break;
            }
            case DOUBLE: {
                value = "333333333333333333333333.0";
                break;
            }
            case FILE: {
                value = "C:/autoexec.bat";
                break;
            }
            case DIRECTORY: {
                value = "/usr/bin";
            }
        }
        return new PropertySimple(propertyDefinitionSimple.getName(), (Object)value);
    }

    private static PropertyMap generatePropertyMap(PropertyDefinitionMap propertyDefinitionMap) {
        PropertyMap propertyMap = new PropertyMap(propertyDefinitionMap.getName());
        Map childPropertyDefinitions = propertyDefinitionMap.getPropertyDefinitions();
        if (childPropertyDefinitions.isEmpty()) {
            for (int i = 0; i < 10; ++i) {
                propertyMap.put((Property)new PropertySimple("openMapMember" + i, (Object)("value" + i)));
            }
        } else {
            for (PropertyDefinition childPropertyDefinition : childPropertyDefinitions.values()) {
                SimpleConfigurationFactory.generateProperty(childPropertyDefinition, (AbstractPropertyMap)propertyMap);
            }
        }
        return propertyMap;
    }
}

