/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.perftest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.perftest.ScenarioManager;

public class PerfTestRogueComponent
implements ResourceComponent,
OperationFacet,
ConfigurationFacet {
    private Log log = LogFactory.getLog(PerfTestRogueComponent.class);
    private ResourceContext resourceContext;
    private Configuration resourceConfiguration;

    public void start(ResourceContext context) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = context;
        ScenarioManager scenarioManager = ScenarioManager.getInstance();
        if (!scenarioManager.isEnabled()) {
            this.log.warn((Object)("[" + this.resourceContext.getResourceType().getName() + "] perftest Resources exist in inventory, but no Perf test scenario is enabled."));
        }
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    public Configuration loadResourceConfiguration() throws Exception {
        if (this.resourceConfiguration == null) {
            Configuration config = new Configuration();
            config.put((Property)new PropertySimple("updateSleep", (Object)"1000"));
            config.put((Property)new PropertySimple("updateStatus", (Object)"success"));
            config.put((Property)new PropertySimple("loadSleep", (Object)"1000"));
            config.put((Property)new PropertySimple("loadStatus", (Object)"success"));
            this.resourceConfiguration = config;
        } else {
            PropertySimple sleepProp = (PropertySimple)this.resourceConfiguration.get("loadSleep");
            Long sleep = sleepProp.getLongValue();
            PropertySimple statusProp = (PropertySimple)this.resourceConfiguration.get("loadStatus");
            String status = statusProp.getStringValue();
            try {
                this.log.info((Object)("The rogue component (config-load) was told to sleep: " + sleep + "ms"));
                Thread.sleep(sleep);
                this.log.info((Object)("The rogue component (config-load) has finished its sleep of " + sleep + "ms"));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (!status.equalsIgnoreCase("success")) {
                throw new Exception("Rogue component (config-load) was told to throw an exception (status=[" + status + "])");
            }
        }
        return this.resourceConfiguration;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        Configuration newConfig = report.getConfiguration();
        PropertySimple sleepProp = (PropertySimple)newConfig.get("updateSleep");
        Long sleep = sleepProp.getLongValue();
        PropertySimple statusProp = (PropertySimple)newConfig.get("updateStatus");
        String status = statusProp.getStringValue();
        try {
            this.log.info((Object)("The rogue component (config) was told to sleep: " + sleep + "ms"));
            Thread.sleep(sleep);
            this.log.info((Object)("The rogue component (config) has finished its sleep of " + sleep + "ms"));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.resourceConfiguration = newConfig;
        if (status.equalsIgnoreCase("success")) {
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        } else if (status.equalsIgnoreCase("failure")) {
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
        } else {
            throw new RuntimeException("Rogue component (config) was told to throw an exception (status=[" + status + "])");
        }
    }

    public OperationResult invokeOperation(String name, Configuration parameters) {
        PropertySimple sleepProp = (PropertySimple)parameters.get("sleep");
        Long sleep = sleepProp.getLongValue();
        PropertySimple statusProp = (PropertySimple)parameters.get("status");
        String status = statusProp.getStringValue();
        try {
            this.log.info((Object)("The rogue component (op) was told to sleep: " + sleep + "ms"));
            Thread.sleep(sleep);
            this.log.info((Object)("The rogue component (op) has finished its sleep of " + sleep + "ms"));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        OperationResult result = new OperationResult();
        if (!status.equalsIgnoreCase("success")) {
            if (status.equalsIgnoreCase("failure")) {
                result.setErrorMessage("Rogue component was told to fail this operation");
            } else {
                throw new RuntimeException("Rogue component (op) was told to throw an exception (status=[" + status + "])");
            }
        }
        return result;
    }
}

