/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.util.Collections;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.platform.ProcessComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessDiscoveryComponent
implements ResourceDiscoveryComponent,
ManualAddFacet {
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext resourceDiscoveryContext) throws InvalidPluginConfigurationException, Exception {
        return Collections.emptySet();
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfig, ResourceDiscoveryContext resourceDiscoveryContext) throws InvalidPluginConfigurationException {
        ProcessInfo processInfo;
        try {
            processInfo = ProcessComponent.getProcessForConfiguration(pluginConfig, resourceDiscoveryContext.getSystemInformation());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create process based on plugin config: " + pluginConfig);
        }
        String type = pluginConfig.getSimpleValue("type", "pidFile");
        String resourceKey = pluginConfig.getSimpleValue(type, null);
        if (resourceKey == null || resourceKey.length() == 0) {
            throw new InvalidPluginConfigurationException("Invalid type [" + type + "] value [" + resourceKey + "]");
        }
        ResourceType resourceType = resourceDiscoveryContext.getResourceType();
        String resourceName = processInfo.getBaseName();
        String resourceVersion = null;
        String resourceDescription = null;
        DiscoveredResourceDetails detail = new DiscoveredResourceDetails(resourceType, resourceKey, resourceName, resourceVersion, resourceDescription, pluginConfig, processInfo);
        return detail;
    }
}

