/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.tool.pluginvalidator;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.rhq.core.pc.plugin.PluginFinder;
import org.rhq.core.pc.plugin.PluginValidator;
import org.rhq.core.pc.plugin.SimplePluginFinder;

public class PluginValidatorMojo
extends AbstractMojo {
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        URL pluginUrl;
        Log log = this.getLog();
        log.info((CharSequence)"Validating RHQ Plugin");
        String pluginJarName = this.project.getArtifactId() + "-" + this.project.getVersion() + ".jar";
        String pluginDirectory = this.project.getBuild().getDirectory();
        log.debug((CharSequence)("Plugin JAR: " + pluginJarName));
        log.debug((CharSequence)("Plugin Directory: " + pluginDirectory));
        File pluginFile = new File(pluginDirectory, pluginJarName);
        if (!pluginFile.exists()) {
            throw new MojoFailureException("Cannot find plugin");
        }
        try {
            pluginUrl = pluginFile.toURL();
        }
        catch (MalformedURLException e) {
            throw new MojoFailureException("Could not load URL for plugin file: " + pluginFile);
        }
        log.info((CharSequence)("Plugin descriptor directory URL:" + pluginUrl));
        SimplePluginFinder finder = new SimplePluginFinder(pluginUrl);
        boolean success = PluginValidator.validatePlugins((PluginFinder)finder);
        if (!success) {
            log.info((CharSequence)"--------------------------");
            log.info((CharSequence)"Plugin Validation: FAILURE");
            log.info((CharSequence)"--------------------------");
            throw new MojoFailureException("Plugin validation failed. Check the rest of the log for more information.");
        }
        log.info((CharSequence)"--------------------------");
        log.info((CharSequence)"Plugin Validation: SUCCESS");
        log.info((CharSequence)"--------------------------");
    }
}

