/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.admin.ListAlertTemplatesUIBean;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.alert.AlertTemplateManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ListAlertTemplatesUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "ListAlertTemplatesUIBean";
    private ResourceType resourceType;
    private AlertTemplateManagerLocal alertTemplateManager = LookupUtil.getAlertTemplateManager();
    private AuthorizationManagerLocal authorizationManager = LookupUtil.getAuthorizationManager();

    public String createNewAlertTemplate() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        boolean isAuthorized = this.authorizationManager.hasGlobalPermission(subject, Permission.MANAGE_SETTINGS);
        if (!isAuthorized) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"User is not authorized to create new alert templates");
            return "success";
        }
        return "createNewAlertTemplate";
    }

    public String deleteSelectedAlertTemplates() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selectedAlertDefinitions = this.getSelectedAlertDefinitions();
        Integer[] alertDefinitionIds = this.getIntegerArray(selectedAlertDefinitions);
        try {
            this.alertTemplateManager.removeAlertTemplates(subject, alertDefinitionIds);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Deleted " + alertDefinitionIds.length + " alert definitions."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to delete alert definitions.", (Throwable)e);
        }
        return "success";
    }

    public String enableSelectedAlertTemplates() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selectedAlertDefinitions = this.getSelectedAlertDefinitions();
        Integer[] alertDefinitionIds = this.getIntegerArray(selectedAlertDefinitions);
        try {
            this.alertTemplateManager.enableAlertTemplates(subject, alertDefinitionIds);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Enabled " + alertDefinitionIds.length + " alert definitions."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to enable alert definitions.", (Throwable)e);
        }
        return "success";
    }

    public String disableSelectedAlertTemplates() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selectedAlertDefinitions = this.getSelectedAlertDefinitions();
        Integer[] alertDefinitionIds = this.getIntegerArray(selectedAlertDefinitions);
        try {
            this.alertTemplateManager.disableAlertTemplates(subject, alertDefinitionIds);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Disabled " + alertDefinitionIds.length + " alert definitions."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to disable alert definitions.", (Throwable)e);
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ListAlertTemplatesDataModel(this, PageControlView.AlertTemplatesList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private String[] getSelectedAlertDefinitions() {
        return FacesContextUtility.getRequest().getParameterValues("selectedAlertTemplates");
    }

    private Integer[] getIntegerArray(String[] input) {
        Integer[] output = new Integer[input.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = Integer.valueOf(input[i]);
        }
        return output;
    }

    static /* synthetic */ ResourceType access$000(ListAlertTemplatesUIBean x0) {
        return x0.resourceType;
    }

    static /* synthetic */ ResourceType access$002(ListAlertTemplatesUIBean x0, ResourceType x1) {
        x0.resourceType = x1;
        return x0.resourceType;
    }
}

