/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.role;

import java.util.HashMap;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.authz.Role;
import org.rhq.enterprise.gui.legacy.Portal;
import org.rhq.enterprise.gui.legacy.action.BaseDispatchAction;
import org.rhq.enterprise.gui.legacy.exception.ParameterNotFoundException;
import org.rhq.enterprise.gui.legacy.util.ActionUtils;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RoleManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class RoleAdminPortalAction
extends BaseDispatchAction {
    private static final String TITLE_LIST = "admin.role.ListRolesTitle";
    private static final String PORTLET_LIST = ".admin.role.List";
    private static final String TITLE_ADD_USERS = "admin.role.AddRoleUsersTitle";
    private static final String PORTLET_ADD_USERS = ".admin.role.AddUsers";
    private static final String TITLE_ADD_GROUPS = "admin.role.AddRoleGroupsTitle";
    private static final String PORTLET_ADD_GROUPS = ".admin.role.AddGroups";
    private static final String TITLE_EDIT = "admin.role.EditRoleTitle";
    private static final String PORTLET_EDIT = ".admin.role.Edit";
    private static final String TITLE_NEW = "admin.role.NewRoleTitle";
    private static final String PORTLET_NEW = ".admin.role.New";
    private static final String TITLE_VIEW = "admin.role.ViewRoleTitle";
    private static final String PORTLET_VIEW = ".admin.role.View";
    private static final String TITLE_CHANGE_OWNER = "admin.role.ChangeRoleOwnerTitle";
    private static final String PORTLET_CHANGE_OWNER = ".admin.role.ChangeOwner";
    protected static final Log log = LogFactory.getLog((String)RoleAdminPortalAction.class.getName());
    private static Properties keyMethodMap = new Properties();

    protected Properties getKeyMethodMap() {
        return keyMethodMap;
    }

    public ActionForward listRoles(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setReturnPath(request, mapping, "list");
        Portal portal = Portal.createPortal((String)TITLE_LIST, (String)PORTLET_LIST);
        portal.setWorkflowPortal(true);
        request.setAttribute("portal", (Object)portal);
        return null;
    }

    public ActionForward addRoleUsers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setRole(request);
        Portal portal = Portal.createPortal((String)TITLE_ADD_USERS, (String)PORTLET_ADD_USERS);
        portal.setDialog(true);
        request.setAttribute("portal", (Object)portal);
        return null;
    }

    public ActionForward addRoleGroups(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setRole(request);
        Portal portal = Portal.createPortal((String)TITLE_ADD_GROUPS, (String)PORTLET_ADD_GROUPS);
        portal.setDialog(true);
        request.setAttribute("portal", (Object)portal);
        return null;
    }

    public ActionForward editRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setRole(request);
        Role role = (Role)request.getAttribute("Role");
        if (role.getFsystem().booleanValue()) {
            RequestUtils.setError((HttpServletRequest)request, (String)"admin.role.error.EditPermission");
            throw new PermissionException();
        }
        Portal portal = Portal.createPortal((String)TITLE_EDIT, (String)PORTLET_EDIT);
        portal.setDialog(true);
        request.setAttribute("portal", (Object)portal);
        return null;
    }

    public ActionForward newRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Portal portal = Portal.createPortal((String)TITLE_NEW, (String)PORTLET_NEW);
        portal.setDialog(true);
        request.setAttribute("portal", (Object)portal);
        return null;
    }

    public ActionForward viewRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setRole(request);
        this.setReturnPath(request, mapping, "view");
        Portal portal = Portal.createPortal((String)TITLE_VIEW, (String)PORTLET_VIEW);
        portal.setWorkflowPortal(true);
        request.setAttribute("portal", (Object)portal);
        return null;
    }

    public ActionForward changeRoleOwner(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setRole(request);
        Portal portal = Portal.createPortal((String)TITLE_CHANGE_OWNER, (String)PORTLET_CHANGE_OWNER);
        portal.setDialog(true);
        request.setAttribute("portal", (Object)portal);
        return null;
    }

    protected void setRole(HttpServletRequest request) throws Exception {
        Integer roleId = RequestUtils.getRoleId((HttpServletRequest)request);
        ServletContext ctx = this.getServlet().getServletContext();
        if (log.isTraceEnabled()) {
            log.trace((Object)("finding role [" + roleId + "]"));
        }
        RoleManagerLocal roleManager = LookupUtil.getRoleManager();
        Role role = roleManager.getRoleById(roleId);
        request.setAttribute("Role", (Object)role);
        request.setAttribute("TitleParam", (Object)role.getName());
    }

    protected void setReturnPath(HttpServletRequest request, ActionMapping mapping, String mode) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mode", mode);
        try {
            params.put("r", RequestUtils.getRoleId((HttpServletRequest)request));
        }
        catch (ParameterNotFoundException e) {
            // empty catch block
        }
        String returnPath = ActionUtils.findReturnPath((ActionMapping)mapping, params);
        if (log.isTraceEnabled()) {
            log.trace((Object)("setting return path: " + returnPath));
        }
        SessionUtils.setReturnPath((HttpSession)request.getSession(), (String)returnPath);
    }

    static {
        keyMethodMap.setProperty("list", "listRoles");
        keyMethodMap.setProperty("addUsers", "addRoleUsers");
        keyMethodMap.setProperty("addGroups", "addRoleGroups");
        keyMethodMap.setProperty("edit", "editRole");
        keyMethodMap.setProperty("new", "newRole");
        keyMethodMap.setProperty("view", "viewRole");
        keyMethodMap.setProperty("changeOwner", "changeRoleOwner");
    }
}

