/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.alert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.jboss.seam.log.Log;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertDampening;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.gui.alert.AlertConditionsUIBean;
import org.rhq.enterprise.gui.alert.AlertDescriber;
import org.rhq.enterprise.gui.alert.converter.MetricAbsoluteConverter;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@Scope(value=ScopeType.PAGE)
@Name(value="alertConditionsUIBean")
public class AlertConditionsUIBean {
    private static final String SUCCESS_OUTCOME = "success";
    @Logger
    private Log log;
    @In
    private FacesMessages facesMessages;
    @In(value="#{webUser.subject}")
    private Subject subject;
    @In
    private ResourceType resourceType;
    @In
    private AlertDefinitionManagerLocal alertDefinitionManager;
    @In
    private MeasurementDefinitionManagerLocal measurementDefinitionManager;
    @In
    private ConfigurationManagerLocal configurationManager;
    @In
    private AlertDefinition alertDefinition;
    @In
    private AlertDescriber alertDescriber;
    private MetricAbsoluteConverter metricAbsoluteConverter = new MetricAbsoluteConverter();
    private Map<String, String> categories;
    private List<ConditionDescription> conditionDescriptions;
    private AlertCondition currentCondition;
    private Integer measurementDefinitionId = 0;
    private Double threshold;
    private Integer resourceId;

    @RequestParameter(value="id")
    public void setResourceId(Integer resourceId) {
        if (resourceId != null) {
            this.resourceId = resourceId;
        }
    }

    public String getMeasurementDefinitionId() {
        if (this.measurementDefinitionId != null) {
            return this.measurementDefinitionId.toString();
        }
        return null;
    }

    public void setMeasurementDefinitionId(String measurementDefinitionId) {
        try {
            this.measurementDefinitionId = Integer.parseInt(measurementDefinitionId);
        }
        catch (NumberFormatException e) {
            this.measurementDefinitionId = null;
        }
    }

    public String getThreshold() {
        if (this.threshold != null) {
            return this.threshold.toString();
        }
        return null;
    }

    public void setThreshold(String threshold) {
        this.threshold = Double.parseDouble(threshold);
    }

    public List<ConditionDescription> getConditionDescriptions() {
        return this.conditionDescriptions;
    }

    public Map<String, String> getCategories() {
        return this.categories;
    }

    public AlertCondition getCurrentCondition() {
        return this.currentCondition;
    }

    public void setCurrentCondition(AlertCondition currentCondition) {
        MeasurementDefinition measurement;
        this.currentCondition = currentCondition;
        if (this.shouldSetMeasurementDefinition() && (measurement = this.currentCondition.getMeasurementDefinition()) != null) {
            this.setMeasurementDefinitionId(Integer.toString(measurement.getId()));
            if (this.currentCondition.getCategory() == AlertConditionCategory.THRESHOLD) {
                this.threshold = this.metricAbsoluteConverter.getForDisplay(this.currentCondition.getThreshold(), measurement);
            }
        }
    }

    @Create
    public void init() {
        this.conditionDescriptions = this.createDescriptions();
        this.categories = this.createCategories();
        this.createCondition();
    }

    private List<ConditionDescription> createDescriptions() {
        Set conditions = this.alertDefinition.getConditions();
        ArrayList<ConditionDescription> descriptions = new ArrayList<ConditionDescription>(conditions.size());
        for (AlertCondition condition : conditions) {
            descriptions.add(new ConditionDescription(this, condition));
        }
        return descriptions;
    }

    public void createCondition() {
        this.setCurrentCondition(new AlertCondition());
    }

    public void updateCondition() {
        if (this.shouldSetMeasurementDefinition()) {
            MeasurementDefinition measurementDefinition = this.measurementDefinitionManager.getMeasurementDefinition(this.subject, this.measurementDefinitionId.intValue());
            this.currentCondition.setMeasurementDefinition(measurementDefinition);
            this.currentCondition.setName(measurementDefinition.getDisplayName());
            if (measurementDefinition != null && this.threshold != null) {
                this.currentCondition.setThreshold(this.metricAbsoluteConverter.getForThreshold(this.threshold, measurementDefinition));
            }
        }
        for (ConditionDescription description : this.conditionDescriptions) {
            if (!ConditionDescription.access$000((ConditionDescription)description).equals((Object)this.currentCondition)) continue;
            ConditionDescription.access$102((ConditionDescription)description, (String)this.alertDescriber.describeCondition(ConditionDescription.access$000((ConditionDescription)description)));
            return;
        }
        this.conditionDescriptions.add(new ConditionDescription(this, this.currentCondition));
    }

    public void removeCondition() {
        this.conditionDescriptions.remove(this.findCurrentDescription());
        this.setCurrentCondition(null);
    }

    public String saveAlertDefinition() {
        if (!this.validateDefinition()) {
            return null;
        }
        this.alertDefinition.setConditions(this.findConditions());
        try {
            this.alertDefinitionManager.updateAlertDefinition(this.subject, this.alertDefinition.getId(), this.alertDefinition, true);
        }
        catch (Exception e) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, "There was an error saving the alert conditions.", new Object[0]);
            this.log.error((Object)("Error persisting AlertDefinition:  " + this.alertDefinition.getName()), (Throwable)e, new Object[0]);
            return null;
        }
        return "success";
    }

    public String newAlertDefinition() {
        if (!this.validateDefinition()) {
            return null;
        }
        this.alertDefinition.setConditions(this.findConditions());
        try {
            this.alertDefinitionManager.createAlertDefinition(this.subject, this.alertDefinition, this.resourceId);
        }
        catch (Exception e) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, "There was an error creating the alert definition.", new Object[0]);
            this.log.error((Object)("Error persisting AlertDefinition:  " + this.alertDefinition.getName()), (Throwable)e, new Object[0]);
            return null;
        }
        return "success";
    }

    private boolean validateDefinition() {
        Set conditions = this.findConditions();
        if (conditions.isEmpty()) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, "Please add at least one condition.", new Object[0]);
            return false;
        }
        AlertDampening dampening = this.alertDefinition.getAlertDampening();
        if (dampening.getCategory() == AlertDampening.Category.PARTIAL_COUNT && dampening.getValue() > dampening.getPeriod()) {
            this.facesMessages.addFromResourceBundle(StatusMessage.Severity.ERROR, "alert.config.error.PartialCountRangeTooSmall", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean shouldSetMeasurementDefinition() {
        if (this.currentCondition != null) {
            AlertConditionCategory category = this.currentCondition.getCategory();
            return category == AlertConditionCategory.TRAIT || category == AlertConditionCategory.CHANGE || category == AlertConditionCategory.THRESHOLD || category == AlertConditionCategory.BASELINE;
        }
        return false;
    }

    private ConditionDescription findCurrentDescription() {
        for (ConditionDescription description : this.conditionDescriptions) {
            if (ConditionDescription.access$000((ConditionDescription)description) != this.currentCondition) continue;
            return description;
        }
        return null;
    }

    private Set<AlertCondition> findConditions() {
        HashSet<AlertCondition> conditionSet = new HashSet<AlertCondition>(this.conditionDescriptions.size());
        for (ConditionDescription description : this.conditionDescriptions) {
            conditionSet.add(ConditionDescription.access$000((ConditionDescription)description));
        }
        return conditionSet;
    }

    private Map<String, String> createCategories() {
        HashMap<String, String> categoryMap = new HashMap<String, String>();
        ArrayList<AlertConditionCategory> categoryList = new ArrayList<AlertConditionCategory>(Arrays.asList(AlertConditionCategory.values()));
        categoryList.remove(AlertConditionCategory.ALERT);
        if (this.configurationManager.getResourceConfigurationDefinitionForResourceType(this.subject, this.resourceType.getId()) == null) {
            categoryList.remove(AlertConditionCategory.RESOURCE_CONFIG);
        }
        for (AlertConditionCategory category : categoryList) {
            categoryMap.put(category.toString(), category.getName());
        }
        return categoryMap;
    }

    static /* synthetic */ AlertDescriber access$200(AlertConditionsUIBean x0) {
        return x0.alertDescriber;
    }
}

