/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.alert;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.notification.NotificationTemplate;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.PAGE)
@Name(value="definitionNotificationsUIBean")
public class DefinitionNotificationsUIBean
implements Serializable {
    @In
    private AlertDefinition alertDefinition;
    @In
    private AlertNotificationManagerLocal alertNotificationManager;
    @In(value="#{webUser.subject}")
    private Subject subject;
    private String selectedTemplate;
    private Boolean clearExistingNotifications;
    private Map<String, String> notificationTemplates;

    public AlertDefinition getAlertDefinition() {
        return this.alertDefinition;
    }

    public String getSelectedTemplate() {
        return this.selectedTemplate;
    }

    public void setSelectedTemplate(String selectedTemplate) {
        this.selectedTemplate = selectedTemplate;
    }

    public Boolean getClearExistingNotifications() {
        return this.clearExistingNotifications;
    }

    public void setClearExistingNotifications(Boolean clearExistingNotifications) {
        this.clearExistingNotifications = clearExistingNotifications;
    }

    public Map<String, String> getNotificationTemplates() {
        return this.notificationTemplates;
    }

    public String addAlertSenderFromTemplate() {
        this.alertNotificationManager.applyNotificationTemplateToAlertDefinition(this.getSelectedTemplate(), this.alertDefinition.getId(), this.getClearExistingNotifications().booleanValue());
        return "success";
    }

    @Create
    public void init() {
        this.notificationTemplates = this.lookupNotificationTemplates();
    }

    private Map<String, String> lookupNotificationTemplates() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        List templates = this.alertNotificationManager.listNotificationTemplates(this.subject);
        for (NotificationTemplate template : templates) {
            String displayName = this.getNotificationDisplayName(template);
            result.put(displayName, template.getName());
        }
        return result;
    }

    private String getNotificationDisplayName(NotificationTemplate template) {
        StringBuilder builder = new StringBuilder(template.getName());
        builder.append(" (");
        builder.append(template.getDescription());
        builder.append(")");
        return builder.toString();
    }
}

