/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.alert.description;

import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.util.MeasurementConverter;
import org.rhq.enterprise.gui.alert.description.AlertConditionDescriber;
import org.rhq.enterprise.server.measurement.util.MeasurementFormatter;

public class BaselineDescriber
extends AlertConditionDescriber {
    public AlertConditionCategory[] getDescribedCategories() {
        return this.makeCategories(new AlertConditionCategory[]{AlertConditionCategory.BASELINE});
    }

    public void createDescription(AlertCondition condition, StringBuilder builder) {
        builder.append(condition.getName());
        builder.append(' ');
        builder.append(condition.getComparator());
        builder.append(' ');
        builder.append(this.getMeasurementDescription(condition));
        builder.append(" of ");
        builder.append(MeasurementFormatter.getBaselineText((String)condition.getOption(), null));
    }

    private String getMeasurementDescription(AlertCondition condition) {
        double threshold = condition.getThreshold();
        return MeasurementConverter.format((Double)threshold, (MeasurementUnits)MeasurementUnits.PERCENTAGE, (boolean)true);
    }
}

