/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.error;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.util.StringUtil;
import org.rhq.enterprise.server.alert.engine.internal.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericErrorUIBean {
    private final Log log = LogFactory.getLog(GenericErrorUIBean.class);
    String summary;
    String details;
    List<Tuple<String, String>> trace;

    public GenericErrorUIBean() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        Map sessionMap = externalContext.getSessionMap();
        this.trace = new ArrayList();
        Throwable ex = (Exception)sessionMap.remove("GLOBAL_RENDER_ERROR");
        this.log.error((Object)"Error processing user request", ex);
        String message = ex.getLocalizedMessage();
        String stack = StringUtil.getFirstStackTrace((Throwable)ex);
        this.trace.add(new Tuple((Object)message, (Object)stack));
        while (ex.getCause() != null) {
            ex = ex.getCause();
            message = ex.getLocalizedMessage();
            stack = StringUtil.getFirstStackTrace((Throwable)ex);
            this.trace.add(new Tuple((Object)message, (Object)stack));
        }
        this.summary = ex.getClass().getSimpleName();
        this.details = ex.getMessage();
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDetails() {
        return this.details;
    }

    public List<Tuple<String, String>> getTrace() {
        return this.trace;
    }
}

