/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.framework;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.jboss.seam.core.Manager;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesMessagePropogationPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 5393413660742308456L;
    private static final String SAVED_GLOBAL_FACES_MESSAGES = "SAVED_GLOBAL_FACES_MESSAGES";

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void beforePhase(PhaseEvent event) {
        PhaseId phaseId = event.getPhaseId();
        if (phaseId == PhaseId.RESTORE_VIEW) {
            List savedMessages = this.removeGlobalFacesMessagesFromSession();
            this.putGlobalFacesMessagesInFacesContext(savedMessages);
        }
    }

    public void afterPhase(PhaseEvent event) {
        PhaseId phaseId = event.getPhaseId();
        if (phaseId == PhaseId.INVOKE_APPLICATION) {
            if (!Manager.instance().isReallyLongRunningConversation()) {
                this.putGlobalFacesMessagesInSession();
            }
        } else if (phaseId == PhaseId.RENDER_RESPONSE) {
            this.removeGlobalFacesMessagesFromSession();
        }
    }

    private void putGlobalFacesMessagesInSession() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Iterator messages = facesContext.getMessages();
        ArrayList<FacesMessage> savedMessages = new ArrayList<FacesMessage>();
        while (messages.hasNext()) {
            FacesMessage message = (FacesMessage)messages.next();
            savedMessages.add(message);
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        Map sessionMap = externalContext.getSessionMap();
        sessionMap.put(SAVED_GLOBAL_FACES_MESSAGES, savedMessages);
    }

    @Nullable
    private List<FacesMessage> removeGlobalFacesMessagesFromSession() {
        Map sessionMap = this.getSessionMap();
        return (List)sessionMap.remove(SAVED_GLOBAL_FACES_MESSAGES);
    }

    private void putGlobalFacesMessagesInFacesContext(@Nullable List<FacesMessage> messages) {
        if (messages == null) {
            return;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!facesContext.getMessages().hasNext()) {
            for (FacesMessage message : messages) {
                facesContext.addMessage(null, message);
            }
        }
    }

    private Map<String, Object> getSessionMap() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        return externalContext.getSessionMap();
    }
}

