/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.servlet;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.calltime.CallTimeDataComposite;
import org.rhq.enterprise.gui.common.servlet.ChartServlet;
import org.rhq.enterprise.gui.image.chart.Chart;
import org.rhq.enterprise.gui.image.chart.DataPoint;
import org.rhq.enterprise.gui.image.chart.PerfDataPointCollection;
import org.rhq.enterprise.gui.image.chart.StackedPerformanceChart;
import org.rhq.enterprise.gui.image.data.IDataPoint;
import org.rhq.enterprise.gui.legacy.util.ChartData;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.rt.SegmentInfo;

public class PerformanceChartServlet
extends ChartServlet {
    private Log log = LogFactory.getLog((String)PerformanceChartServlet.class.getName());
    private String perfChartType = null;
    private int numCharts = 0;
    private String m_destinationType;
    private static final int DEFAULT_PERF_IMAGE_HEIGHT = 300;
    private static final int DEFAULT_PERF_IMAGE_WIDTH = 755;
    public static final String PERF_CHART_TYPE_PARAM = "perfChartType";
    public static final String CHART_TYPE_URL = "url";
    public static final String CHART_TYPE_URLDETAIL = "urldetail";
    public static final String CHART_TYPE_TYPE = "type";
    private static final String[] VALID_PERF_CHART_TYPES = new String[]{"url", "urldetail", "type"};
    private static final String WEBSERVER_LABEL_PROPERTY = "resource.common.monitor.visibility.VitualHostHeaderTH";
    private static final String APPSERVER_LABEL_PROPERTY = "resource.common.monitor.visibility.WebappHeaderTH";
    private static final String ENDUSER_LABEL_PROPERTY = "resource.common.monitor.visibility.EndUserHeaderTH";
    private static final String LOW_LABEL_PROPERTY = "resource.common.monitor.visibility.LowTH";
    private static final String AVG_LABEL_PROPERTY = "resource.common.monitor.visibility.AvgTH";
    private static final String PEAK_LABEL_PROPERTY = "resource.common.monitor.visibility.PeakTH";

    protected void parseParameters(HttpServletRequest request) {
        String tmpPerfChartType = this.parseRequiredStringParameter(request, PERF_CHART_TYPE_PARAM, VALID_PERF_CHART_TYPES);
        this.setPerfChartType(tmpPerfChartType);
        HttpSession session = request.getSession(false);
        ChartData chartData = (ChartData)session.getAttribute("chartData");
        if (chartData != null) {
            if (this.perfChartType.equals(CHART_TYPE_URL) || this.perfChartType.equals(CHART_TYPE_TYPE)) {
                this.setNumCharts(chartData.getSummaries().size());
            } else if (this.perfChartType.equals(CHART_TYPE_URLDETAIL)) {
                this.setNumCharts(chartData.getSegments().size());
            }
            if (this.units == null || this.units == MeasurementUnits.NONE) {
                this.units = chartData.getMeasurementDefinition().getUnits();
            }
            this.m_destinationType = chartData.getMeasurementDefinition().getDestinationType();
        }
        super.parseParameters(request);
    }

    protected Chart createChart() {
        return new StackedPerformanceChart(this.getImageWidth(), this.getNumCharts(), this.m_destinationType);
    }

    protected void plotData(HttpServletRequest request, Chart chart) throws ServletException {
        StackedPerformanceChart perfChart = (StackedPerformanceChart)chart;
        HttpSession session = request.getSession(false);
        ChartData chartData = (ChartData)session.getAttribute("chartData");
        if (chartData == null) {
            this.log.debug((Object)"Did not find performance chart data to plot.");
            return;
        }
        HashMap<String, String> mlabels = new HashMap<String, String>();
        mlabels.put(LOW_LABEL_PROPERTY, RequestUtils.message((HttpServletRequest)request, (String)LOW_LABEL_PROPERTY));
        mlabels.put(AVG_LABEL_PROPERTY, RequestUtils.message((HttpServletRequest)request, (String)AVG_LABEL_PROPERTY));
        mlabels.put(PEAK_LABEL_PROPERTY, RequestUtils.message((HttpServletRequest)request, (String)PEAK_LABEL_PROPERTY));
        if (this.isTypeChart() || this.isUrlChart()) {
            List summaries = chartData.getSummaries();
            perfChart.setNumberDataSets(summaries.size());
            Iterator summariesIter = summaries.iterator();
            Iterator barsIter = perfChart.getDataSetIterator();
            while (summariesIter.hasNext() && barsIter.hasNext()) {
                PerfDataPointCollection bars = (PerfDataPointCollection)barsIter.next();
                CallTimeDataComposite summary = (CallTimeDataComposite)summariesIter.next();
                Integer segmentId = null;
                this.fillOutSummarySection(bars, chartData, summary, segmentId, mlabels);
            }
        } else if (this.isUrlDetailChart()) {
            // empty if block
        }
        session.removeAttribute("chartData");
    }

    private void fillOutSummarySection(PerfDataPointCollection bars, ChartData data, CallTimeDataComposite summary, Integer segmentId, Map mlabels) {
        if (segmentId != null) {
            bars.setType(segmentId.intValue());
        }
        bars.setURL(summary.getCallDestination());
        if (data.getShowReq() != null && data.getShowReq().booleanValue()) {
            bars.setRequest((int)summary.getCount());
        }
        if (data.getShowLow() != null && data.getShowLow().booleanValue()) {
            bars.add((IDataPoint)new DataPoint(summary.getMinimum(), (String)mlabels.get(LOW_LABEL_PROPERTY)));
        }
        if (data.getShowAvg() != null && data.getShowAvg().booleanValue()) {
            bars.add((IDataPoint)new DataPoint(summary.getAverage(), (String)mlabels.get(AVG_LABEL_PROPERTY)));
        }
        if (data.getShowPeak() != null && data.getShowPeak().booleanValue()) {
            bars.add((IDataPoint)new DataPoint(summary.getMaximum(), (String)mlabels.get(PEAK_LABEL_PROPERTY)));
        }
    }

    private void addDataPoint(PerfDataPointCollection bars, SegmentInfo segInfo, String label) {
        if (segInfo != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("adding " + label + " value: " + segInfo.getSegments()));
            }
            segInfo.setLabel(label);
            bars.add((IDataPoint)segInfo);
        } else {
            bars.add((IDataPoint)new DataPoint(Double.NaN, label));
        }
    }

    protected int getDefaultImageHeight() {
        return 300;
    }

    protected int getDefaultImageWidth() {
        return 755;
    }

    public String getPerfChartType() {
        return this.perfChartType;
    }

    public void setPerfChartType(String type) {
        this.perfChartType = type;
    }

    public int getNumCharts() {
        return this.numCharts;
    }

    public void setNumCharts(int size) {
        this.numCharts = size;
    }

    public boolean isTypeChart() {
        return this.getPerfChartType().equals(CHART_TYPE_TYPE);
    }

    public boolean isUrlChart() {
        return this.getPerfChartType().equals(CHART_TYPE_URL);
    }

    public boolean isUrlDetailChart() {
        return this.getPerfChartType().equals(CHART_TYPE_URLDETAIL);
    }
}

