/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.tag;

import com.sun.facelets.tag.AbstractTagLibrary;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.rhq.core.clientapi.util.units.DateFormatter;
import org.rhq.core.clientapi.util.units.FormatSpecifics;
import org.rhq.core.clientapi.util.units.FormattedNumber;
import org.rhq.core.clientapi.util.units.ScaleConstants;
import org.rhq.core.clientapi.util.units.UnitNumber;
import org.rhq.core.clientapi.util.units.UnitsConstants;
import org.rhq.core.clientapi.util.units.UnitsFormat;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.composite.ResourceFacets;
import org.rhq.core.domain.resource.composite.ResourcePermission;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.tag.FunctionTagLibrary;
import org.rhq.enterprise.gui.legacy.WebUserPreferences;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.common.EntityContext;
import org.rhq.enterprise.server.measurement.uibean.MetricDisplaySummary;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class FunctionTagLibrary
extends AbstractTagLibrary {
    public static final String ELLIPSIS = "\u2026";
    public static final String NAMESPACE = "http://jboss.org/on/function";
    public static final FunctionTagLibrary INSTANCE = new FunctionTagLibrary();
    private static final String AMP = "&amp;";

    public FunctionTagLibrary() {
        super("http://jboss.org/on/function");
        try {
            Method[] methods;
            for (Method method : methods = FunctionTagLibrary.class.getMethods()) {
                if (!Modifier.isStatic(method.getModifiers())) continue;
                this.addFunction(method.getName(), method);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void loadResource() {
        EnterpriseFacesContextUtility.getResource();
    }

    public static ResourceFacets getResourceFacets(int resourceTypeId) {
        ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();
        return resourceTypeManager.getResourceFacets(resourceTypeId);
    }

    public static ResourceFacets getFacets() {
        Resource resource = EnterpriseFacesContextUtility.getResource();
        ResourceType resourceType = resource.getResourceType();
        int resourceTypeId = resourceType.getId();
        return FunctionTagLibrary.getResourceFacets((int)resourceTypeId);
    }

    public static ResourcePermission getResourcePermission() {
        AuthorizationManagerLocal authorizationManager = LookupUtil.getAuthorizationManager();
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        Resource resource = EnterpriseFacesContextUtility.getResource();
        Set resourcePerms = authorizationManager.getImplicitResourcePermissions(subject, resource.getId());
        return new ResourcePermission(resourcePerms);
    }

    public static ResourcePermission getGroupPermission(int groupId) {
        AuthorizationManagerLocal authorizationManager = LookupUtil.getAuthorizationManager();
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        Set groupPerms = authorizationManager.getImplicitGroupPermissions(subject, groupId);
        return new ResourcePermission(groupPerms);
    }

    @Deprecated
    public static String formatTimestamp(long timestamp) {
        UnitsConstants unit = UnitsConstants.UNIT_DATE;
        String key = "unit.format.epoch-millis";
        String formatString = RequestUtils.message((HttpServletRequest)FacesContextUtility.getRequest(), (String)key);
        DateFormatter.DateSpecifics specs = new DateFormatter.DateSpecifics();
        specs.setDateFormat((DateFormat)new SimpleDateFormat(formatString));
        FormattedNumber fmtd = UnitsFormat.format((UnitNumber)new UnitNumber((double)timestamp, unit, ScaleConstants.SCALE_MILLI), (Locale)FacesContextUtility.getRequest().getLocale(), (FormatSpecifics)specs);
        return fmtd.toString();
    }

    public static int sizeOf(Collection<?> collection) {
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }

    public static <T> int length(T[] collection) {
        if (collection == null) {
            return 0;
        }
        return collection.length;
    }

    public static WebUserPreferences getWebUserPreferences() {
        return EnterpriseFacesContextUtility.getWebUser().getWebPreferences();
    }

    public static String contextFragmentURL() {
        EntityContext context = WebUtility.getEntityContext();
        switch (1.$SwitchMap$org$rhq$enterprise$server$common$EntityContext$Category[context.category.ordinal()]) {
            case 1: {
                return "id=" + String.valueOf(context.resourceId);
            }
            case 2: {
                return "groupId=" + String.valueOf(context.groupId);
            }
            case 3: {
                return "parent=" + String.valueOf(context.parentResourceId) + "&" + "type" + "=" + String.valueOf(context.resourceTypeId);
            }
        }
        throw new IllegalArgumentException(context.getUnknownContextMessage());
    }

    public static String contextFragmentURLForIndicatorsChart() {
        EntityContext context = WebUtility.getEntityContext();
        switch (1.$SwitchMap$org$rhq$enterprise$server$common$EntityContext$Category[context.category.ordinal()]) {
            case 3: {
                return "parent=" + String.valueOf(context.parentResourceId) + "&" + "ctype" + "=" + String.valueOf(context.resourceTypeId);
            }
        }
        return FunctionTagLibrary.contextFragmentURL();
    }

    public static Resource getResource(int resourceId) {
        Subject user = EnterpriseFacesContextUtility.getSubject();
        return LookupUtil.getResourceManager().getResourceById(user, resourceId);
    }

    public static String elideString(String str, int numChars, String mode) {
        return FunctionTagLibrary.elideStringCustom((String)str, (int)numChars, (String)mode, (String)"\u2026");
    }

    public static String elideStringCustom(String str, int numChars, String mode, String ellipsis) {
        ElideMode eMode = Enum.valueOf(ElideMode.class, mode.toUpperCase());
        return FunctionTagLibrary.elideString((String)str, (int)numChars, (ElideMode)eMode, (String)ellipsis);
    }

    private static String elideString(String str, int numChars, ElideMode mode, String ellipsis) {
        if (str == null) {
            throw new IllegalArgumentException("Cannot elide a null string");
        }
        if (ellipsis == null) {
            throw new IllegalArgumentException("Ellipsis can't be null when eliding a string");
        }
        if (numChars >= str.length()) {
            return str;
        }
        int ellipsisLength = ellipsis.length();
        StringBuilder result = new StringBuilder(numChars);
        if (mode == ElideMode.LEFT) {
            result.append(ellipsis);
            result.append(str.substring(str.length() - numChars - ellipsisLength + 1, str.length()));
        } else if (mode == ElideMode.MIDDLE) {
            int firstHalf = (numChars - ellipsisLength) / 2;
            int secondHalf = firstHalf + (numChars - ellipsisLength) % 2;
            result.append(str.substring(0, firstHalf));
            result.append(ellipsis);
            result.append(str.substring(str.length() - secondHalf + 1, str.length()));
        } else if (mode == ElideMode.RIGHT) {
            result.append(str.substring(0, numChars - ellipsisLength + 1));
            result.append(ellipsis);
        }
        return result.toString();
    }

    public static String getChartURLParams(MetricDisplaySummary summary) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(FunctionTagLibrary.contextFragmentURL()).append("&amp;");
        buffer.append("imageWidth=647").append("&amp;");
        buffer.append("imageHeight=100").append("&amp;");
        buffer.append("schedId=").append(FunctionTagLibrary.formatNullURLParams((Object)summary.getScheduleId())).append("&amp;");
        buffer.append("definitionId=").append(FunctionTagLibrary.formatNullURLParams((Object)summary.getDefinitionId())).append("&amp;");
        buffer.append("measurementUnits=").append(FunctionTagLibrary.formatNullURLParams((Object)summary.getUnits())).append("&amp;");
        buffer.append("now=").append(System.currentTimeMillis());
        return buffer.toString();
    }

    public static <T> List<T> getListFromMap(Map<String, T> map) {
        ArrayList<T> results = new ArrayList<T>();
        results.addAll(map.values());
        return results;
    }

    private static String formatNullURLParams(Object value) {
        String valueStr = value == null ? null : value.toString();
        return valueStr == null ? "" : valueStr;
    }

    public static String getDefaultContextTabURL(EntityContext context) {
        if (context.category == EntityContext.Category.Resource) {
            return FunctionTagLibrary.getDefaultResourceTabURL();
        }
        if (context.category == EntityContext.Category.ResourceGroup) {
            return "/rhq/group/monitor/graphs.xhtml";
        }
        if (context.category == EntityContext.Category.AutoGroup) {
            return "/rhq/autogroup/monitor/graphs.xhtml";
        }
        throw new IllegalArgumentException("Do not support getting defaultTabURL for " + context);
    }

    public static String getDefaultResourceTabURL() {
        return "/rhq/resource/summary/overview.xhtml";
    }

    public static String getDefaultGroupTabURL() {
        return "/rhq/group/inventory/view.xhtml";
    }

    public static String getAvailabilityURL(AvailabilityType type, int size) {
        if (size != 16 && size != 24) {
            throw new IllegalArgumentException("No availability icon for size " + size);
        }
        if (type == null) {
            return size == 16 ? "/images/icons/availability_gray_16.png" : "/images/icons/availability_gray_24.png";
        }
        if (type == AvailabilityType.UP) {
            return size == 16 ? "/images/icons/availability_green_16.png" : "/images/icons/availability_green_24.png";
        }
        if (type == AvailabilityType.DOWN) {
            return size == 16 ? "/images/icons/availability_red_16.png" : "/images/icons/availability_red_24.png";
        }
        throw new IllegalArgumentException("No icon for AvailabilityType[" + type + "]");
    }

    public static String getAlertPriorityURL(AlertPriority priority) {
        switch (1.$SwitchMap$org$rhq$core$domain$alert$AlertPriority[priority.ordinal()]) {
            case 1: {
                return "/images/icons/Flag_red_16.png";
            }
            case 2: {
                return "/images/icons/Flag_yellow_16.png";
            }
            case 3: {
                return "/images/icons/Flag_blue_16.png";
            }
        }
        throw new IllegalArgumentException("No icon for AlertPriority[" + priority + "]");
    }

    public static String getResourceConfigStatusURL(ConfigurationUpdateStatus status) {
        switch (1.$SwitchMap$org$rhq$core$domain$configuration$ConfigurationUpdateStatus[status.ordinal()]) {
            case 1: {
                return "/images/icons/Configure_ok_16.png";
            }
            case 2: {
                return "/images/icons/Configure_failed_16.png";
            }
            case 3: {
                return "/images/icons/Configure_16.png";
            }
        }
        throw new IllegalArgumentException("No icon for ConfigurationUpdateStatus[" + status + "]");
    }

    public static String getOperationStatusURL(OperationRequestStatus status) {
        switch (1.$SwitchMap$org$rhq$core$domain$operation$OperationRequestStatus[status.ordinal()]) {
            case 1: {
                return "/images/icons/Operation_ok_16.png";
            }
            case 2: {
                return "/images/icons/Operation_failed_16.png";
            }
            case 3: {
                return "/images/icons/Operation_16.png";
            }
            case 4: {
                return "/images/icons/Operation_cancel_16.png";
            }
        }
        throw new IllegalArgumentException("No icon for OperationRequestStatus[" + status + "]");
    }

    public static String getEventSeverityURL(EventSeverity severity, boolean grouped) {
        String color = null;
        switch (1.$SwitchMap$org$rhq$core$domain$event$EventSeverity[severity.ordinal()]) {
            case 1: {
                color = "debug";
                break;
            }
            case 2: {
                color = "info";
                break;
            }
            case 3: {
                color = "warning";
                break;
            }
            case 4: {
                color = "error";
                break;
            }
            case 5: {
                color = "fatal";
                break;
            }
            default: {
                throw new IllegalArgumentException("No icon for EventSeverity[" + severity + "]");
            }
        }
        String additional = grouped ? "_multi" : "";
        return "/images/icons/Events_" + color + additional + "_16.png";
    }
}

