/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.time.converter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.WebUserPreferences;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;

public class UserDateTimeConverter
implements Converter {
    public SimpleDateFormat getFormatter() {
        WebUser user = EnterpriseFacesContextUtility.getWebUser();
        WebUserPreferences preferences = user.getWebPreferences();
        WebUserPreferences.DateTimeDisplayPreferences displayPreferences = preferences.getDateTimeDisplayPreferences();
        displayPreferences.getClass();
        String pattern = "M/d/yy, h:mm:ss aa, zzz";
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df;
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        SimpleDateFormat df = this.getFormatter();
        try {
            Date timestampAsDate = df.parse(value);
            Long timestampAsLong = timestampAsDate.getTime();
            return timestampAsLong;
        }
        catch (ParseException pe) {
            return 0L;
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        SimpleDateFormat df = this.getFormatter();
        Long timestampAsLong = (Long)value;
        String timestampAsString = df.format(timestampAsLong);
        return timestampAsString;
    }
}

