/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.upload;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;

public class UploadRenderer
extends Renderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = component.getClientId(context);
        writer.startElement("input", component);
        writer.writeAttribute("type", (Object)"file", "type");
        writer.writeAttribute("name", (Object)clientId, "clientId");
        writer.endElement("input");
        writer.flush();
    }

    public void decode(FacesContext context, UIComponent component) {
        Object target;
        ExternalContext external = context.getExternalContext();
        HttpServletRequest request = (HttpServletRequest)external.getRequest();
        String clientId = component.getClientId(context);
        FileItem item = (FileItem)request.getAttribute(clientId);
        ValueExpression valueExpression = component.getValueExpression("value");
        if (valueExpression != null) {
            Object newValue;
            Class valueType = valueExpression.getType(context.getELContext());
            if (valueType == byte[].class) {
                newValue = item.get();
            } else if (valueType == InputStream.class) {
                try {
                    newValue = item.getInputStream();
                }
                catch (IOException ex) {
                    throw new FacesException((Throwable)ex);
                }
            } else {
                String encoding = request.getCharacterEncoding();
                if (encoding != null) {
                    try {
                        newValue = item.getString(encoding);
                    }
                    catch (UnsupportedEncodingException ex) {
                        newValue = item.getString();
                    }
                } else {
                    newValue = item.getString();
                }
            }
            ((EditableValueHolder)component).setSubmittedValue(newValue);
            ((EditableValueHolder)component).setValid(true);
        }
        if ((target = component.getAttributes().get("target")) != null) {
            File file;
            if (target instanceof File) {
                file = (File)target;
            } else {
                ServletContext servletContext = (ServletContext)external.getContext();
                String realPath = servletContext.getRealPath(target.toString());
                file = new File(realPath);
            }
            try {
                item.write(file);
            }
            catch (Exception ex) {
                throw new FacesException((Throwable)ex);
            }
        }
    }
}

