/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.configuration.group;

import java.util.Map;
import javax.faces.application.FacesMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.gui.configuration.propset.ConfigurationSet;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.configuration.group.GroupResourceConfigurationUtility;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.configuration.ConfigurationUpdateStillInProgressException;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGroupResourceConfigurationUIBean {
    private final Log log = LogFactory.getLog(AbstractGroupResourceConfigurationUIBean.class);
    private ConfigurationManagerLocal configurationManager = LookupUtil.getConfigurationManager();
    private ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
    private ResourceGroup group;
    private Map<Integer, Configuration> resourceConfigurations;
    private ConfigurationSet configurationSet;

    protected void loadConfigurations() {
        try {
            this.group = this.loadGroup();
            this.resourceConfigurations = this.configurationManager.getResourceConfigurationsForCompatibleGroup(EnterpriseFacesContextUtility.getSubject(), this.group.getId());
        }
        catch (ConfigurationUpdateStillInProgressException updateException) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_WARN, (String)"Configuration update is currently in progress. Please wait a few moments and refresh the page.");
            return;
        }
        catch (RuntimeException e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_FATAL, (String)"Failed to load group Resource configuration.", (Throwable)e);
            this.log.error((Object)"Failed to load group Resource configuration.", (Throwable)e);
            return;
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Cannot load group Resource configuration.", (Throwable)e);
            return;
        }
        if (this.resourceConfigurations.isEmpty()) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_WARN, (String)"Cannot load group Resource configuration, this group has no members");
        } else {
            this.configurationSet = GroupResourceConfigurationUtility.buildConfigurationSet((Subject)EnterpriseFacesContextUtility.getSubject(), (ResourceGroup)this.group, (Map)this.resourceConfigurations);
        }
    }

    private ResourceGroup loadGroup() throws Exception {
        ResourceGroup group;
        try {
            group = EnterpriseFacesContextUtility.getResourceGroup();
        }
        catch (Exception e) {
            throw new Exception("No group is associated with this request ('groupId' request parameter is not set).");
        }
        if (group.getGroupCategory() != GroupCategory.COMPATIBLE) {
            throw new Exception("Group with id " + group.getId() + " is not a compatible group.");
        }
        return group;
    }

    public ConfigurationManagerLocal getConfigurationManager() {
        return this.configurationManager;
    }

    public ResourceManagerLocal getResourceManager() {
        return this.resourceManager;
    }

    public ResourceGroup getGroup() {
        return this.group;
    }

    public Map<Integer, Configuration> getResourceConfigurations() {
        return this.resourceConfigurations;
    }

    public ConfigurationSet getConfigurationSet() {
        return this.configurationSet;
    }
}

