/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.content.ListContentSourcesUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ListContentSourcesUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "ListContentSourcesUIBean";
    private ContentSourceManagerLocal contentSourceManager = LookupUtil.getContentSourceManager();

    public String createNewContentSource() {
        return "createNewContentSource";
    }

    public String deleteSelectedContentSources() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selected = this.getSelectedContentSources();
        Integer[] ids = this.getIntegerArray(selected);
        if (ids.length > 0) {
            try {
                for (Integer id : ids) {
                    this.contentSourceManager.deleteContentSource(subject, id.intValue());
                }
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Deleted [" + ids.length + "] content providers."));
            }
            catch (Exception e) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to delete content providers.", (Throwable)e);
            }
        }
        return "success";
    }

    public String syncSelectedContentSources() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selected = this.getSelectedContentSources();
        Integer[] ids = this.getIntegerArray(selected);
        if (ids.length > 0) {
            try {
                for (Integer id : ids) {
                    this.contentSourceManager.synchronizeAndLoadContentSource(subject, id.intValue());
                }
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Synchronizing [" + ids.length + "] content providers."));
            }
            catch (Exception e) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to synchronized content providers.", (Throwable)e);
            }
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ListContentSourcesDataModel(this, PageControlView.ContentSourcesList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private String[] getSelectedContentSources() {
        return FacesContextUtility.getRequest().getParameterValues("selectedContentProviders");
    }

    private Integer[] getIntegerArray(String[] input) {
        if (input == null) {
            return new Integer[0];
        }
        Integer[] output = new Integer[input.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = Integer.valueOf(input[i]);
        }
        return output;
    }
}

