/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import java.util.List;
import javax.faces.model.DataModel;
import javax.faces.model.SelectItem;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.content.ListPackageTypesUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.ContentUIManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPackageTypesUIBean
extends PagedDataTableUIBean {
    public List<PackageType> getPackageTypesForResourceType() {
        Resource resource = EnterpriseFacesContextUtility.getResource();
        ContentUIManagerLocal contentUIManager = LookupUtil.getContentUIManager();
        List packageTypes = contentUIManager.getPackageTypes(resource.getResourceType().getId());
        return packageTypes;
    }

    public SelectItem[] getSelectablePackageTypes() {
        List packageTypes = this.getPackageTypesForResourceType();
        SelectItem[] selection = new SelectItem[packageTypes.size()];
        int index = 0;
        for (PackageType type : packageTypes) {
            selection[index++] = new SelectItem((Object)type, type.getDisplayName());
        }
        return selection;
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ListPackageTypesDataModel(this, PageControlView.PackageTypesList, "ListPackageTypesUIBean");
        }
        return this.dataModel;
    }
}

