/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.content.ListReposUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ListReposUIBean
extends PagedDataTableUIBean {
    private final Log log = LogFactory.getLog(ListReposUIBean.class);
    public static final String MANAGED_BEAN_NAME = "ListReposUIBean";
    private RepoManagerLocal repoManager = LookupUtil.getRepoManagerLocal();
    private ContentSourceManagerLocal contentSourceManager = LookupUtil.getContentSourceManager();

    public String createNewRepo() {
        return "createNewRepo";
    }

    public String importRepos() {
        return "importRepos";
    }

    public String syncSelectedRepos() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selected = this.getSelectedRepos();
        Integer[] repoIds = this.getIntegerArray(selected);
        if (repoIds.length > 0) {
            int syncCount = 0;
            try {
                syncCount = this.repoManager.synchronizeRepos(subject, repoIds);
            }
            catch (Exception e) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to delete repositories.", (Throwable)e);
            }
            if (syncCount > 0) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Synchronizing [" + syncCount + "] content providers."));
            } else {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Selected Repositories have no content to sync.");
            }
        }
        return "success";
    }

    public String deleteSelectedRepos() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selected = this.getSelectedRepos();
        Integer[] ids = this.getIntegerArray(selected);
        if (ids.length > 0) {
            try {
                for (Integer id : ids) {
                    this.repoManager.deleteRepo(subject, id.intValue());
                }
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Deleted [" + ids.length + "] repositories."));
            }
            catch (Exception e) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to delete repositories.", (Throwable)e);
            }
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ListReposDataModel(this, PageControlView.ReposList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private String[] getSelectedRepos() {
        return FacesContextUtility.getRequest().getParameterValues("selectedRepos");
    }

    private Integer[] getIntegerArray(String[] input) {
        if (input == null) {
            return new Integer[0];
        }
        Integer[] output = new Integer[input.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = Integer.valueOf(input[i]);
        }
        return output;
    }
}

