/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.content.RepoDisassociationsUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class RepoDisassociationsUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "RepoDisassociationsUIBean";

    public String associateSelectedContentSourcesWithRepo() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selected = this.getSelectedRepoDisassociations();
        int repoId = Integer.valueOf(FacesContextUtility.getRequiredRequestParameter((String)"id"));
        int[] contentSourceIds = this.getIntegerArray(selected);
        if (contentSourceIds != null && contentSourceIds.length > 0) {
            try {
                RepoManagerLocal manager = LookupUtil.getRepoManagerLocal();
                manager.addContentSourcesToRepo(subject, repoId, contentSourceIds);
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Associated [" + contentSourceIds.length + "] content providers with repo"));
            }
            catch (Exception e) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to associate one or more content providers with repo", (Throwable)e);
            }
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new RepoDisassociationsDataModel(this, PageControlView.RepoDisassociationsList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private String[] getSelectedRepoDisassociations() {
        return FacesContextUtility.getRequest().getParameterValues("selectedRepoDisassociations");
    }

    private int[] getIntegerArray(String[] input) {
        if (input == null) {
            return new int[0];
        }
        int[] output = new int[input.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = Integer.valueOf(input[i]);
        }
        return output;
    }
}

