/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.image.chart;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import org.rhq.enterprise.gui.image.chart.ChartGraphics;
import org.rhq.enterprise.gui.image.chart.ColumnChart;
import org.rhq.enterprise.gui.image.chart.DataPointCollection;
import org.rhq.enterprise.gui.image.data.IDataPoint;

public class AreaChart
extends ColumnChart {
    public AreaChart() {
    }

    public AreaChart(int width, int height) {
        super(width, height);
    }

    protected void init() {
        super.init();
        this.valueIndent = 0;
    }

    protected void paint(ChartGraphics g, Rectangle rect) {
        g.graphics.setColor(this.columnColor);
        DataPointCollection coll = this.getDataPoints();
        Iterator iter = coll.iterator();
        Rectangle rectBar = new Rectangle();
        rectBar.width = rect.width / coll.size();
        int index = 0;
        while (iter.hasNext()) {
            Point ptData;
            IDataPoint datapt = (IDataPoint)iter.next();
            if (!Double.isNaN(datapt.getValue()) && (ptData = this.getDataPoint(rect, index, coll)) != null) {
                rectBar.x = ptData.x;
                rectBar.y = ptData.y;
                rectBar.height = rect.y + rect.height - rectBar.y;
                g.graphics.fillRect(rectBar.x, rectBar.y, rectBar.width, rectBar.height);
            }
            ++index;
        }
    }
}

