/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.image.chart;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import org.rhq.enterprise.gui.image.chart.ChartGraphics;
import org.rhq.enterprise.gui.image.chart.ColumnChart;
import org.rhq.enterprise.gui.image.chart.DataPointCollection;
import org.rhq.enterprise.gui.image.data.IDataPoint;
import org.rhq.enterprise.gui.image.data.IHighLowDataPoint;

public class HighLowChart
extends ColumnChart {
    protected static final Color DEFAULT_HIGHLOW_COLOR = new Color(0, 0, 128);
    protected static final int DEFAULT_HIGHLOW_HEIGHT = 125;
    public Color highLowColor = DEFAULT_HIGHLOW_COLOR;

    public HighLowChart() {
        this(755);
    }

    public HighLowChart(int width) {
        super(width, 125);
    }

    public HighLowChart(int width, int height) {
        super(width, height);
    }

    protected void init() {
        super.init();
        this.showLeftLabels = false;
        this.showBottomLabels = false;
        this.showBottomLegend = false;
        this.valueLines = 5;
        this.showAverage = false;
        this.showPeak = false;
        this.showLow = false;
        this.showBaseline = false;
        this.showHighRange = true;
        this.showLowRange = true;
    }

    public Color getHighLowLineColor() {
        return this.highLowColor;
    }

    public void setHighLowLineColor(Color value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.highLowColor = value;
    }

    protected void paint(ChartGraphics g, Rectangle rect) {
        int halfcol = this.columnWidth / 2;
        Rectangle rectBar = new Rectangle();
        rectBar.width = this.columnWidth;
        DataPointCollection coll = this.getDataPoints();
        int collSize = coll.size();
        for (int index = 0; index < collSize; ++index) {
            IHighLowDataPoint datapt;
            IDataPoint obj = coll.get(index);
            if (!(obj instanceof IHighLowDataPoint) || Double.isNaN((datapt = (IHighLowDataPoint)obj).getValue()) || Double.isNaN(datapt.getHighValue()) || Double.isNaN(datapt.getLowValue())) continue;
            Point ptHigh = this.adjustBorders(this.getDisplayPoint(rect.height, rect.width, collSize, datapt.getHighValue(), index));
            Point ptLow = this.adjustBorders(this.getDisplayPoint(rect.height, rect.width, collSize, datapt.getLowValue(), index));
            Point ptAvg = this.adjustBorders(this.getDisplayPoint(rect.height, rect.width, collSize, datapt.getValue(), index));
            ptHigh.x -= halfcol;
            ptLow.x -= halfcol;
            ptAvg.x -= halfcol;
            rectBar.x = ptHigh.x;
            rectBar.y = ptHigh.y;
            rectBar.height = ptLow.y - ptHigh.y;
            g.graphics.setColor(DEFAULT_COLUMN_COLOR);
            g.graphics.fillRect(rectBar.x, rectBar.y, rectBar.width, rectBar.height);
            g.graphics.setColor(this.highLowColor);
            g.graphics.drawLine(ptAvg.x, ptAvg.y, ptAvg.x + rectBar.width - 1, ptAvg.y);
            g.graphics.drawOval(ptAvg.x + halfcol - 1, ptAvg.y - 1, 2, 2);
        }
    }

    protected void calcRanges() {
        DataPointCollection coll = this.getDataPoints();
        for (Object obj : coll) {
            IHighLowDataPoint datapt;
            if (!(obj instanceof IHighLowDataPoint) || Double.isNaN((datapt = (IHighLowDataPoint)obj).getHighValue()) || Double.isNaN(datapt.getLowValue())) continue;
            this.m_dPeakValue = Math.max(this.m_dPeakValue, datapt.getHighValue());
            this.m_dLowValue = Math.min(this.m_dLowValue, datapt.getLowValue());
        }
        super.calcRanges();
    }
}

