/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.image.chart;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.util.MeasurementConverter;
import org.rhq.enterprise.gui.image.chart.Chart;
import org.rhq.enterprise.gui.image.chart.ChartGraphics;
import org.rhq.enterprise.gui.image.chart.DataPointCollection;
import org.rhq.enterprise.gui.image.chart.ScaleFormatter;
import org.rhq.enterprise.gui.image.data.IDataPoint;
import org.rhq.enterprise.gui.image.data.IDisplayDataPoint;
import org.rhq.enterprise.gui.image.data.IHighLowDataPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerticalChart
extends Chart {
    protected static final Color[] DEFAULT_COLORS = new Color[]{new Color(0, 0, 255), new Color(255, 0, 0), new Color(204, 0, 153), new Color(155, 186, 112), new Color(255, 255, 51), new Color(0, 255, 0), new Color(0, 255, 255), new Color(166, 120, 56), new Color(153, 102, 153), new Color(116, 144, 170)};
    protected static final Color GOOD_COLOR = new Color(72, 179, 104);
    protected static final Color DANGER_COLOR = new Color(213, 62, 62);
    protected static final Color UNKNOWN_COLOR = new Color(0, 0, 204);
    private Rectangle m_rect;
    private long m_timeScale;
    private int m_cumulativeTrend = 0;

    public VerticalChart() {
        this.init();
    }

    public int getCumulativeTrend() {
        return this.m_cumulativeTrend;
    }

    public void setCumulativeTrend(int trend) {
        if (trend < 0 || trend > 2) {
            throw new IllegalArgumentException("Argument must be a Cumulative type.");
        }
        this.m_cumulativeTrend = trend;
    }

    protected VerticalChart(int width, int height) {
        super(width, height);
        this.init();
    }

    protected VerticalChart(int charts) {
        super(charts);
        this.init();
    }

    protected VerticalChart(int width, int height, int charts) {
        super(width, height, charts);
        this.init();
    }

    protected void init() {
        this.showAverage = true;
        this.showValueLines = true;
        this.showLow = true;
        this.showPeak = true;
    }

    protected Collection<DataPointCollection> initData(Collection<DataPointCollection> coll) {
        if (this.m_fmtUnits == MeasurementUnits.PERCENTAGE) {
            this.floor = 0.0;
            this.ceiling = 1.0;
            for (DataPointCollection dpc : coll) {
                for (IDataPoint point : dpc) {
                    double ref = point instanceof IHighLowDataPoint ? ((IHighLowDataPoint)point).getHighValue() : point.getValue();
                    if (!(ref > this.ceiling)) continue;
                    this.ceiling = ref;
                }
            }
        }
        return coll;
    }

    protected Point adjustBorders(Point pt) {
        if (pt != null) {
            pt.x += this.m_rect.x;
            pt.y += this.m_rect.y;
        }
        return pt;
    }

    protected Rectangle adjustRectangle(Graphics2D g, Rectangle rect) {
        int cDataPts = this.getDataPoints().size();
        int spread = this.getUnitSpread(g, rect);
        rect.width = spread * (cDataPts - 1) + this.valueIndent * 2 + this.lineWidth;
        this.m_rect = rect;
        return rect;
    }

    protected Rectangle getInteriorRectangle(ChartGraphics g) {
        return this.m_rect;
    }

    protected String[] getXLabels() {
        DataPointCollection coll = this.getDataPoints();
        int collSize = coll.size();
        String[] result = new String[collSize];
        for (int i = 0; i < collSize; ++i) {
            IDisplayDataPoint dp = (IDisplayDataPoint)coll.get(i);
            result[i] = ScaleFormatter.formatTime((long)dp.getTimestamp(), (long)this.m_timeScale, (long)collSize);
        }
        return result;
    }

    protected int[] getXPoints(ChartGraphics g, Rectangle rect) {
        DataPointCollection coll = this.getDataPoints();
        int collSize = coll.size();
        int[] res = new int[collSize];
        int spread = this.getUnitSpread(g.graphics, this.getInteriorRectangle(g));
        int xHorzMarks = rect.x + this.valueIndent;
        int i = 0;
        int x = xHorzMarks;
        while (i < collSize) {
            res[i] = x;
            ++i;
            x += spread;
        }
        return res;
    }

    private int getUnitSpread(Graphics2D g, Rectangle rect) {
        int cDataPts = this.getDataPoints().size();
        int iSpread = rect.width - this.valueIndent * 2;
        return cDataPts > 1 ? iSpread / (cDataPts - 1) : iSpread;
    }

    protected int getYLabelWidth(Graphics2D g) {
        int maxWidth = 0;
        String[] formatted = MeasurementConverter.formatToSignificantPrecision((double[])this.m_adRangeMarks, (MeasurementUnits)this.m_fmtUnits, (boolean)true);
        for (int i = 0; i < formatted.length; ++i) {
            int width = this.m_metricsLabel.stringWidth(formatted[i]);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth;
    }

    protected Rectangle draw(ChartGraphics g) {
        Rectangle rect = super.draw(g);
        if (!this.hasData()) {
            return rect;
        }
        Graphics2D graph = g.graphics;
        double dScale = this.scale(rect.height);
        int x2 = rect.x + rect.width;
        int y2 = rect.y + rect.height;
        int yAvgLine = y2 - (int)Math.round((this.getAverageValue() - this.m_floor) * dScale);
        int yLowLine = y2 - (int)Math.round((this.getLowValue() - this.m_floor) * dScale);
        int yBaseLine = y2 - (int)Math.round((this.baseline - this.m_floor) * dScale);
        int yPeakLine = y2 - (int)Math.round((this.getPeakValue() - this.m_floor) * dScale);
        int yHighBottom = 0;
        if (!Double.isNaN(this.highRange)) {
            yHighBottom = Math.min(y2 - this.lineWidth, y2 - (int)Math.round((this.highRange - this.m_floor) * dScale));
        }
        yHighBottom = Math.max(yHighBottom, rect.y);
        int yLowTop = 0;
        if (!Double.isNaN(this.lowRange)) {
            yLowTop = Math.max(rect.y + this.lineWidth, y2 - (int)Math.round((this.lowRange - this.m_floor) * dScale));
        }
        yLowTop = Math.min(yLowTop, y2);
        int xAvgLabel = x2 - this.m_metricsLabel.stringWidth("Average") - 3;
        int yAvgLabel = yAvgLine - 3;
        Rectangle avgLabel = new Rectangle();
        if (this.showAverage) {
            avgLabel.setRect(xAvgLabel, yAvgLabel, this.m_metricsLabel.stringWidth("Average"), this.m_metricsLabel.getHeight());
        }
        int xBaselineLabel = x2 - this.m_metricsLabel.stringWidth("Baseline") - 4;
        int yBaselineLabel = yBaseLine - 3;
        Rectangle baselineLabel = new Rectangle();
        if (this.showBaseline) {
            baselineLabel.setRect(xBaselineLabel, yBaselineLabel, this.m_metricsLabel.stringWidth("Baseline"), this.m_metricsLabel.getHeight());
        }
        int xLowLabel = x2 - this.m_metricsLabel.stringWidth("Low") - 4;
        int yLowLabel = yLowLine - 3;
        Rectangle lowLabel = new Rectangle();
        if (this.showLow) {
            lowLabel.setRect(xLowLabel, yLowLabel, this.m_metricsLabel.stringWidth("Low"), this.m_metricsLabel.getHeight());
        }
        int xPeakLabel = x2 - this.m_metricsLabel.stringWidth("Peak") - 4;
        int yPeakLabel = yPeakLine - 3;
        Rectangle peakLabel = new Rectangle();
        if (this.showPeak) {
            peakLabel.setRect(xPeakLabel, yPeakLabel, this.m_metricsLabel.stringWidth("Peak"), this.m_metricsLabel.getHeight());
        }
        if (this.showTopLegend) {
            g.drawYLegendString(this.getValueLegend());
        }
        String[] labels = MeasurementConverter.formatToSignificantPrecision((double[])this.m_adRangeMarks, (MeasurementUnits)this.m_fmtUnits, (boolean)true);
        int[] lines = new int[this.m_adRangeMarks.length];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = rect.y + (int)Math.round((this.m_adRangeMarks[i] - this.m_floor) * dScale);
        }
        g.drawXLines(lines, labels, true);
        boolean bHighLow = false;
        int cxGuide = this.lineWidth * 3;
        int xGuide = rect.x - cxGuide;
        if (this.showHighRange && !Double.isNaN(this.highRange) && yHighBottom > rect.y + this.lineWidth) {
            graph.setColor(this.highRangeColor);
            graph.fillRect(rect.x + this.lineWidth, rect.y + this.lineWidth, rect.width - this.lineWidth, yHighBottom - rect.y);
            graph.setColor(DANGER_COLOR);
            graph.fillRect(xGuide, rect.y + this.lineWidth, cxGuide, yHighBottom - rect.y);
            bHighLow = true;
        }
        if (this.showLowRange && !Double.isNaN(this.lowRange) && yLowTop < y2 - this.lineWidth) {
            graph.setColor(this.lowRangeColor);
            graph.fillRect(rect.x + this.lineWidth, yLowTop, rect.width - this.lineWidth, y2 - yLowTop);
            graph.setColor(DANGER_COLOR);
            graph.fillRect(xGuide, yLowTop, cxGuide, y2 - yLowTop);
            bHighLow = true;
        }
        if (bHighLow) {
            if (!this.showHighRange) {
                yHighBottom = rect.y + this.lineWidth;
            } else {
                ++yHighBottom;
                if (!this.showLowRange) {
                    yLowTop = y2;
                }
            }
            graph.setColor(GOOD_COLOR);
            graph.fillRect(xGuide, yHighBottom, cxGuide, yLowTop - yHighBottom);
        }
        lines = this.getXPoints(g, rect);
        g.drawYLines(lines, this.getXLabels(), false, this.xLabelsSkip);
        if (this.showBottomLegend) {
            g.drawXLegendString(this.getUnitLegend());
        }
        graph.setFont(this.font);
        int xLast = 0;
        if (this.showLow) {
            graph.setColor(this.lowLineColor);
            graph.drawLine(this.xVertMarks, yLowLine, this.x2VertMarks, yLowLine);
            graph.drawString("Low", xLowLabel, yLowLabel);
            xLast = xLowLabel;
        }
        if (this.showAverage) {
            if (avgLabel.intersects(lowLabel)) {
                xAvgLabel = xLast - this.m_metricsLabel.stringWidth("Average") - this.m_metricsLabel.charWidth('W');
            }
            graph.setColor(this.averageLineColor);
            graph.drawLine(this.xVertMarks, yAvgLine, this.x2VertMarks, yAvgLine);
            graph.drawString("Average", xAvgLabel, yAvgLabel);
            xLast = Math.min(xLast, xAvgLabel);
        }
        if (this.showPeak) {
            if (peakLabel.intersects(lowLabel) || peakLabel.intersects(avgLabel)) {
                xPeakLabel = xLast - this.m_metricsLabel.stringWidth("Peak") - this.m_metricsLabel.charWidth('W');
            }
            graph.setColor(this.peakLineColor);
            graph.drawLine(this.xVertMarks, yPeakLine, this.x2VertMarks, yPeakLine);
            graph.drawString("Peak", xPeakLabel, yPeakLabel);
            xLast = Math.min(xLast, xPeakLabel);
        }
        if (this.showBaseline && yBaseLine > rect.y && yBaseLine < y2) {
            if (baselineLabel.intersects(lowLabel) || baselineLabel.intersects(avgLabel) || baselineLabel.intersects(peakLabel)) {
                xBaselineLabel = xLast - this.m_metricsLabel.stringWidth("Baseline") - this.m_metricsLabel.charWidth('W');
            }
            graph.setColor(this.baselineColor);
            graph.drawLine(this.xVertMarks, yBaseLine, this.x2VertMarks, yBaseLine);
            graph.drawString("Baseline", xBaselineLabel, yBaselineLabel);
        }
        if (this.showValues) {
            this.paint(g, rect);
        }
        return rect;
    }

    protected void paint(ChartGraphics graph, Rectangle rect) {
    }

    protected Point getDataPoint(Rectangle rect, int datapoint) {
        return this.getDataPoint(rect, datapoint, this.getDataPoints());
    }

    protected Point getDataPoint(Rectangle rect, int datapoint, DataPointCollection coll) {
        Point ptResult = super.getDataPoint(rect.height, rect.width, datapoint, coll);
        if (ptResult != null) {
            this.adjustBorders(ptResult);
        }
        return ptResult;
    }

    protected void setTimeScale(long scale) {
        this.m_timeScale = scale;
    }

    protected int findDataPointIndex(long timestamp, DataPointCollection coll) {
        int index;
        int collSize = coll.size();
        if (collSize == 0) {
            return -1;
        }
        long first = ((IDisplayDataPoint)coll.get(0)).getTimestamp();
        if (collSize == 1) {
            return first == timestamp ? 0 : -1;
        }
        long second = ((IDisplayDataPoint)coll.get(1)).getTimestamp();
        long interval = second - first;
        long prev = first - interval;
        for (index = 0; index < collSize; ++index) {
            IDisplayDataPoint datapt = (IDisplayDataPoint)coll.get(index);
            if (timestamp > prev && timestamp <= datapt.getTimestamp()) break;
            prev = datapt.getTimestamp();
        }
        return index == collSize ? -1 : index;
    }
}

