/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.image.widget;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import org.rhq.enterprise.gui.image.ImageUtil;
import org.rhq.enterprise.gui.image.Line;
import org.rhq.enterprise.gui.image.WebImage;
import org.rhq.enterprise.gui.image.data.IResourceTreeNode;
import org.rhq.enterprise.gui.image.data.ITreeNode;
import org.rhq.enterprise.gui.image.widget.ResourceTree;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourceTree
extends WebImage {
    private static final int NODE_WHITESPACE = 10;
    private static final int ICON_WHITESPACE = 2;
    private static final int LEVEL_WHITESPACE = 14;
    private static final int LEVEL_DESCENT = 7;
    private static final int LEVEL_INDENT = 0;
    private static final int THIN_LINE = 1;
    private static final int THICK_LINE = 2;
    private static int ICON_HEIGHT;
    private static int ICON_WIDTH;
    private static BufferedImage IMG_RESOURCE;
    private static BufferedImage IMG_AUTO_GROUP;
    private static BufferedImage IMG_CLUSTER;
    protected static final Font NAME_FONT;
    protected static final Font DESC_FONT;
    protected static final Font SELECTED_FONT;
    protected static final Color NAME_COLOR;
    protected static final Color DESC_COLOR;
    protected static final Color LINE_COLOR;
    protected static final Color SOFT_LINE_COLOR;
    protected static final Color SELECTED_COLOR;
    protected static final Color TRANSPARENT_COLOR;
    protected static final Stroke LINE_STROKE;
    private FontMetrics m_nameMetrics;
    private FontMetrics m_descMetrics;
    private Vector m_root = new Vector();
    private Vector m_lines = new Vector();
    private Dimension m_imageSize = new Dimension();
    private int m_yDividerLine;
    private Vector m_testRects = null;

    public ResourceTree(int width) {
        super(width, 1);
    }

    public ResourceTree(int width, int height) {
        super(width, height);
    }

    public void addLevel(IResourceTreeNode[] resources) {
        this.m_root.add(resources);
    }

    public Dimension getImageSize() {
        return this.m_imageSize;
    }

    public IResourceTreeNode[][] getLevels() {
        IResourceTreeNode[][] levels = new IResourceTreeNode[this.m_root.size()][];
        for (int i = 0; i < levels.length; ++i) {
            levels[i] = (IResourceTreeNode[])this.m_root.get(i);
        }
        return levels;
    }

    public void calculateCoordinates() {
        this.calcTree();
    }

    public void reset() {
        this.m_imageSize.setSize(0, 0);
        for (ITreeNode[] nodes : this.m_root) {
            this.resetNodes(nodes);
        }
        this.m_lines.clear();
    }

    private void resetNodes(ITreeNode[] nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException("The 'nodes' argument cannot be null");
        }
        for (int i = 0; i < nodes.length; ++i) {
            ITreeNode node = nodes[i];
            node.reset();
            if (node.hasUpChildren()) {
                this.resetNodes(node.getUpChildren());
            }
            if (!node.hasDownChildren()) continue;
            this.resetNodes(node.getDownChildren());
        }
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append(this.getClass().getName()).append('[').append("Nodes=").append(this.m_root).append(',').append("Lines=").append(this.m_lines).append(',').append("Size=").append(this.m_imageSize).append(',').append("Divider=").append(this.m_yDividerLine).append(']');
        return res.toString();
    }

    protected void addTestRect(Rectangle rect) {
        if (this.m_testRects != null) {
            this.m_testRects.add(new Rectangle(rect));
        }
    }

    protected void draw(Graphics2D g) {
        super.draw(g);
        this.drawLines(g);
        this.drawNodes(g);
    }

    protected void postInit(Graphics2D g) {
        this.font = NAME_FONT;
        this.textColor = NAME_COLOR;
    }

    protected void preInit() {
        this.frameImage = true;
        this.setBorder(7);
        BufferedImage im = new BufferedImage(1, 1, 1);
        Graphics2D g = (Graphics2D)im.getGraphics();
        this.m_nameMetrics = g.getFontMetrics(NAME_FONT);
        this.m_descMetrics = g.getFontMetrics(DESC_FONT);
        g.dispose();
        im.flush();
        Rectangle imageSize = this.calcTree();
        if (imageSize != null) {
            if (imageSize.width <= 0) {
                imageSize.width = 1;
            }
            if (imageSize.height <= 0) {
                imageSize.height = 1;
            }
            this.width = imageSize.width;
            this.height = imageSize.height;
        }
    }

    private Rectangle calcTree() {
        boolean topImage;
        if (this.m_imageSize.width != 0) {
            return null;
        }
        int xLevelLine = 0;
        int yLevelLine = this.topBorder;
        int yFirstLevel = 0;
        int cyLastLevel = 0;
        int cxBorder = this.leftBorder + this.rightBorder;
        Object x = null;
        Object y = null;
        CalcResult childResult = null;
        IResourceTreeNode selected = null;
        Rectangle result = new Rectangle(0, 0, cxBorder, this.topBorder + this.bottomBorder);
        this.m_lines.clear();
        boolean bl = topImage = this.m_root.size() > 1;
        if (!topImage && this.m_root.size() > 0) {
            ITreeNode[] nodes = (ITreeNode[])this.m_root.get(0);
            boolean bl2 = topImage = nodes.length > 1 || !nodes[0].hasDownChildren() && !nodes[0].hasUpChildren();
        }
        if (topImage) {
            Iterator iter = this.m_root.iterator();
            int level = 0;
            while (iter.hasNext()) {
                IResourceTreeNode[] nodes = (IResourceTreeNode[])iter.next();
                xLevelLine = this.leftBorder + 0 * level;
                childResult = this.calcDownChildren(nodes, new Rectangle(xLevelLine, yLevelLine += cyLastLevel, this.width, 0));
                this.addTestRect(CalcResult.access$000((CalcResult)childResult));
                if (selected == null) {
                    selected = CalcResult.access$100((CalcResult)childResult);
                }
                cyLastLevel = CalcResult.access$000((CalcResult)childResult).height + 7;
                result.height += cyLastLevel;
                result.width = Math.max(result.width, CalcResult.access$000((CalcResult)childResult).width + cxBorder);
                if (level == 0) {
                    yFirstLevel = CalcResult.access$200((CalcResult)childResult);
                }
                ++level;
            }
            if (level > 1) {
                this.m_lines.add(new Line(this.leftBorder, yFirstLevel - 1, xLevelLine, CalcResult.access$200(childResult) + 1));
            }
        } else if (this.m_root.size() > 0) {
            selected = ((IResourceTreeNode[])this.m_root.get(0))[0];
        }
        if (selected != null && (selected.hasDownChildren() || selected.hasUpChildren())) {
            Rectangle boundry = new Rectangle();
            boundry.x = this.leftBorder;
            boundry.y = this.topBorder + (topImage ? yLevelLine + cyLastLevel : 0);
            boundry.width = this.width;
            if (topImage) {
                this.m_yDividerLine = boundry.y - 7;
                result.height += 7;
            }
            childResult = this.calcNodeTree(selected, boundry);
            this.addTestRect(CalcResult.access$000((CalcResult)childResult));
            result.height += CalcResult.access$000((CalcResult)childResult).height;
            result.width = Math.max(result.width, CalcResult.access$000((CalcResult)childResult).width + cxBorder);
        } else {
            result.height -= 7;
        }
        result.height -= this.m_descMetrics.getDescent();
        this.m_imageSize.width = result.width;
        this.m_imageSize.height = result.height;
        return result;
    }

    private CalcResult calcNodeTree(IResourceTreeNode node, Rectangle boundry) {
        CalcResult result = null;
        int type = node.getType();
        if (type == 2 || type == 3) {
            Rectangle parentRect = null;
            if (node.hasUpChildren()) {
                parentRect = this.calcNode((IResourceTreeNode)node.getUpChildren()[0], boundry.x, boundry.y);
                boundry.y += parentRect.height;
                boundry.grow(0, -7);
            }
            Rectangle nodeRect = this.calcNode(node, boundry.x, boundry.y);
            this.addTestRect(nodeRect);
            int x = boundry.x + ICON_WIDTH / 2;
            int y = boundry.y + ICON_HEIGHT / 2;
            if (parentRect != null) {
                this.m_lines.add(new Line(parentRect.x + ICON_WIDTH / 2, parentRect.y + ICON_HEIGHT / 2, x, y));
            }
            this.m_lines.add(new Line(x, y, x, boundry.y + 28 + 12));
            y = nodeRect.y + nodeRect.height + 3;
            this.m_lines.add(new Line(x, y, x + 20, y));
            boundry.grow(-10, 0);
            boundry.y = nodeRect.y + nodeRect.height + 7;
            result = this.calcChildren((IResourceTreeNode[])node.getDownChildren(), boundry, true, false, true);
            this.addTestRect(CalcResult.access$000((CalcResult)result));
            CalcResult.access$000((CalcResult)result).width = Math.max(CalcResult.access$000((CalcResult)result).width + ICON_WIDTH, nodeRect.width);
            CalcResult.access$000((CalcResult)result).height += nodeRect.height + 7;
            if (parentRect != null) {
                CalcResult.access$000((CalcResult)result).height += parentRect.height + 7;
            }
        } else {
            IResourceTreeNode[] children = (IResourceTreeNode[])node.getUpChildren();
            if (children != null && children.length > 0) {
                boundry.grow(-10, 0);
                result = this.calcUpChildren(children, boundry);
                this.addTestRect(CalcResult.access$000((CalcResult)result));
                CalcResult.access$000((CalcResult)result).height += 7;
                boundry.x -= 10;
                boundry.y += CalcResult.access$000((CalcResult)result).height;
                CalcResult.access$000((CalcResult)result).x -= 10;
                CalcResult.access$000((CalcResult)result).width += 10;
            }
            Rectangle nodeRect = this.calcNode(node, boundry.x, boundry.y);
            this.addTestRect(nodeRect);
            if (result != null) {
                if (nodeRect.width > CalcResult.access$000((CalcResult)result).width) {
                    CalcResult.access$000((CalcResult)result).width += nodeRect.width - CalcResult.access$000((CalcResult)result).width;
                }
                this.m_lines.add(new Line(nodeRect.x + ICON_WIDTH / 2 + 1, nodeRect.y + ICON_HEIGHT / 2, nodeRect.x + 10 + 1, CalcResult.access$200((CalcResult)result)));
            } else {
                result = new CalcResult(this, null);
                CalcResult.access$002((CalcResult)result, (Rectangle)new Rectangle());
                CalcResult.access$000((CalcResult)result).width += nodeRect.width;
                CalcResult.access$102((CalcResult)result, (IResourceTreeNode)node);
            }
            children = (IResourceTreeNode[])node.getDownChildren();
            if (children != null && children.length > 0) {
                boundry.grow(-10, 0);
                boundry.y += nodeRect.height + 7;
                CalcResult downResult = this.calcDownChildren(children, boundry);
                this.addTestRect(CalcResult.access$000((CalcResult)downResult));
                this.m_lines.add(new Line(nodeRect.x + ICON_WIDTH / 2 + 1, nodeRect.y + ICON_HEIGHT / 2, nodeRect.x + 10 + 1, CalcResult.access$200((CalcResult)downResult)));
                if (result != null) {
                    IResourceTreeNode[] down;
                    CalcResult.access$000((CalcResult)result).height += CalcResult.access$000((CalcResult)downResult).height;
                    if (CalcResult.access$000((CalcResult)downResult).width > CalcResult.access$000((CalcResult)result).width) {
                        CalcResult.access$000((CalcResult)result).width = CalcResult.access$000((CalcResult)downResult).width + CalcResult.access$000((CalcResult)downResult).x - nodeRect.x;
                    }
                    if (children.length == 1 && (down = (IResourceTreeNode[])children[0].getDownChildren()) != null && down.length > 0) {
                        boundry.grow(-20, -(CalcResult.access$000((CalcResult)downResult).height + 7));
                        downResult = this.calcDownChildren(down, boundry);
                        this.addTestRect(CalcResult.access$000((CalcResult)downResult));
                        Rectangle[] rects = children[0].getRectangles();
                        nodeRect = rects[rects.length - 1];
                        this.m_lines.add(new Line(nodeRect.x + ICON_WIDTH / 2 + 1, nodeRect.y + ICON_HEIGHT / 2 + 1, nodeRect.x + 10 + 1, CalcResult.access$200((CalcResult)downResult) + 1));
                        CalcResult.access$000((CalcResult)result).height += CalcResult.access$000((CalcResult)downResult).height + 7;
                        if (CalcResult.access$000((CalcResult)downResult).width > CalcResult.access$000((CalcResult)result).width) {
                            CalcResult.access$000((CalcResult)result).width = CalcResult.access$000((CalcResult)downResult).width + 30;
                        }
                    }
                } else {
                    result = downResult;
                }
                CalcResult.access$000((CalcResult)result).height += 7;
            }
            CalcResult.access$000((CalcResult)result).height += nodeRect.height;
        }
        return result;
    }

    private CalcResult calcChildren(IResourceTreeNode[] nodes, Rectangle boundry, boolean wrap, boolean calcLines, boolean down) {
        int wrapLevel;
        int xNode = 0;
        int yNode = 0;
        int cxLastNode = 0;
        int cyTallestNode = 0;
        int xLevelLine = boundry.x;
        int yLevelLine = boundry.y;
        int xFirstNode = 0;
        int yFirstNode = 0;
        int xLastNode = 0;
        int yLastNode = 0;
        int nodeIndex = 0;
        int lastWrapIndex = 0;
        Rectangle nodeRect = null;
        IResourceTreeNode node = null;
        CalcResult result = new CalcResult(this, null);
        CalcResult.access$002((CalcResult)result, (Rectangle)new Rectangle(boundry.x, boundry.y, 0, 0));
        FontMetrics nameMetrics = this.getFontMetrics();
        Rectangle[] rects = new Rectangle[nodes.length];
        Vector<Line> levelLines = new Vector<Line>();
        int n = wrapLevel = wrap ? 1 : 0;
        while (nodeIndex < nodes.length) {
            int yHorzLine = down ? (wrapLevel > 1 ? yLastNode + cyTallestNode + 7 : yLevelLine) : (wrapLevel > 1 ? yLastNode - cyTallestNode - 14 - 7 : yLevelLine);
            xNode = xLevelLine;
            if (calcLines) {
                xNode += 10;
            }
            if (nodes.length == 1) {
                yNode = yHorzLine;
                if (!down) {
                    yNode += 7;
                }
                yHorzLine += ICON_HEIGHT / 2;
                if (wrapLevel == 0) {
                    xNode -= 2;
                    yLevelLine = yHorzLine;
                }
            } else {
                yNode = yHorzLine + (calcLines ? 7 : 0);
            }
            cyTallestNode = 0;
            int levelStart = nodeIndex;
            while (nodeIndex < nodes.length) {
                node = nodes[nodeIndex];
                if (node.isSelected() && CalcResult.access$100((CalcResult)result) == null) {
                    CalcResult.access$102((CalcResult)result, (IResourceTreeNode)node);
                }
                rects[nodeIndex] = nodeRect = this.calcNode(node, xNode, yNode, false);
                if (nodeRect.x + nodeRect.width > boundry.x + boundry.width && nodeIndex != lastWrapIndex) {
                    if (!wrap) {
                        boundry.grow(-10, 0);
                        result = this.calcChildren(nodes, boundry, true, true, down);
                        boundry.grow(10, 0);
                        return result;
                    }
                    lastWrapIndex = nodeIndex;
                    break;
                }
                cxLastNode = nodeRect.width;
                cyTallestNode = Math.max(cyTallestNode, nodeRect.height);
                if (nodeIndex == 0) {
                    xFirstNode = xNode;
                    yFirstNode = yNode;
                }
                xLastNode = xNode;
                yLastNode = yNode;
                xNode += nodeRect.width + 10;
                ++nodeIndex;
            }
            if (!down) {
                this.swapNodes(rects, levelStart, nodeIndex - 1);
            }
            if (calcLines) {
                Line line = new Line();
                line.x1 = xLevelLine - (wrapLevel == 1 ? 10 : 0);
                line.y1 = yHorzLine;
                line.x2 = nodes.length > 1 ? (down ? xLastNode : rects[levelStart].x) - 5 + ICON_WIDTH / 2 + 1 : xLastNode + ICON_WIDTH / 2;
                levelLines.add(line);
            }
            CalcResult.access$000((CalcResult)result).width = Math.max(CalcResult.access$000((CalcResult)result).width, xLastNode - xLevelLine + cxLastNode + (wrapLevel == 1 ? 10 : 0));
            CalcResult.access$000((CalcResult)result).height = CalcResult.access$000((CalcResult)result).height + (nodeIndex <= 1 && !wrap ? nodeRect.height : nodeRect.height + (calcLines ? 7 : 0));
            ++wrapLevel;
        }
        if (--wrapLevel == 0) {
            wrapLevel = 1;
        }
        for (int i = 0; i < nodes.length; ++i) {
            Rectangle rect = rects[i];
            if (!down) {
                rect.y = wrap ? (rect.y += (cyTallestNode + 14) * (wrapLevel - 1) - 7) : (rect.y -= 7);
            }
            nodes[i].addRectangle(rect.x, rect.y, rect.width, rect.height);
            this.addTestRect(rect);
        }
        Line line = null;
        Iterator iter = levelLines.iterator();
        int i = 0;
        while (iter.hasNext()) {
            line = (Line)iter.next();
            if (!down && nodes.length > 1) {
                line.y1 += (cyTallestNode + 14) * wrapLevel - 7;
            }
            line.y2 = line.y1;
            this.m_lines.add(line);
            if (i == 0) {
                CalcResult.access$202((CalcResult)result, (int)line.y1);
            }
            ++i;
        }
        if (calcLines && wrapLevel >= 1) {
            this.m_lines.add(new Line(xLevelLine + 1, CalcResult.access$200((CalcResult)result), xLevelLine + 1, line.y1));
        }
        if (calcLines && nodes.length > 1) {
            for (i = 0; i < rects.length; ++i) {
                Rectangle rect = rects[i];
                line = new Line();
                line.x1 = rect.x;
                line.y2 = rect.y + 2;
                if (down) {
                    line.y1 = rect.y - 7;
                    line.x2 = rect.x + ICON_WIDTH / 2 - 1;
                } else {
                    line.y1 = rect.y + 7 + rect.height;
                    line.x2 = rect.x + ICON_WIDTH / 2 + 1;
                }
                this.m_lines.add(line);
            }
        }
        if (!calcLines) {
            CalcResult.access$000((CalcResult)result).width -= 10;
        }
        if (wrapLevel > 0) {
            CalcResult.access$000((CalcResult)result).height += (wrapLevel - 1) * 7;
        }
        return result;
    }

    private CalcResult calcDownChildren(IResourceTreeNode[] nodes, Rectangle boundry) {
        return this.calcChildren(nodes, boundry, false, true, true);
    }

    private CalcResult calcUpChildren(IResourceTreeNode[] nodes, Rectangle boundry) {
        return this.calcChildren(nodes, boundry, false, true, false);
    }

    private Rectangle calcNode(IResourceTreeNode node, int x, int y) {
        return this.calcNode(node, x, y, true);
    }

    private Rectangle calcNode(IResourceTreeNode node, int x, int y, boolean set) {
        String name = node.getName();
        String desc = node.getDescription();
        BufferedImage img = ResourceTree.getIcon((int)node.getType());
        int cxImg = img != null ? ICON_WIDTH : 0;
        int cyImg = img != null ? ICON_HEIGHT : 0;
        int cxName = name != null ? this.m_nameMetrics.stringWidth(name) : 0;
        int cxDesc = desc != null ? this.m_descMetrics.stringWidth(desc) : 0;
        int cxNode = Math.max(cxName, cxDesc);
        cxNode += cxImg + 2;
        int cyNode = name != null ? this.m_nameMetrics.getAscent() : 0;
        cyNode += desc != null ? this.m_descMetrics.getAscent() : 0;
        if (set) {
            node.addRectangle(x, y, cxNode, cyNode);
        }
        return new Rectangle(x, y, cxNode, cyNode);
    }

    private void drawLines(Graphics2D g) {
        Stroke strokeOrig = g.getStroke();
        g.setStroke(LINE_STROKE);
        g.setColor(LINE_COLOR);
        for (Line line : this.m_lines) {
            g.drawLine(line.x1, line.y1, line.x2, line.y2);
        }
        g.setStroke(strokeOrig);
    }

    private void drawNodes(Graphics2D g) {
        for (IResourceTreeNode[] nodes : this.m_root) {
            this.drawNodes(g, nodes, NAME_FONT);
        }
    }

    private void drawNodes(Graphics2D g, IResourceTreeNode[] nodes, Font nameFont) {
        int cyAscent = g.getFontMetrics(nameFont).getAscent();
        for (int i = 0; i < nodes.length; ++i) {
            IResourceTreeNode node = nodes[i];
            String name = node.getName();
            String desc = node.getDescription();
            BufferedImage img = ResourceTree.getIcon((int)node.getType());
            Rectangle[] rects = node.getRectangles();
            if (rects == null) continue;
            for (int r = 0; r < rects.length; ++r) {
                Rectangle rect = rects[r];
                int xText = rect.x + 2;
                int yText = rect.y + cyAscent - 3;
                if (img != null) {
                    g.drawImage((Image)img, rect.x, rect.y, null);
                    xText += img.getWidth();
                }
                if (name != null) {
                    g.setColor(node.isSelected() ? SELECTED_COLOR : this.textColor);
                    g.setFont(node.isSelected() ? SELECTED_FONT : nameFont);
                    g.drawString(name, xText, yText);
                }
                if (desc == null) continue;
                g.setColor(DESC_COLOR);
                g.setFont(DESC_FONT);
                g.drawString(desc, xText, yText + this.m_descMetrics.getAscent());
            }
            if (this.m_yDividerLine > 0) {
                g.setColor(DEFAULT_BORDER_COLOR);
                g.drawLine(0, this.m_yDividerLine, this.width - 1, this.m_yDividerLine);
            }
            if (node.hasUpChildren()) {
                this.drawNodes(g, (IResourceTreeNode[])node.getUpChildren(), NAME_FONT);
            }
            if (node.hasDownChildren()) {
                this.drawNodes(g, (IResourceTreeNode[])node.getDownChildren(), NAME_FONT);
            }
            if (this.m_testRects == null) continue;
            g.setColor(DEFAULT_BORDER_COLOR);
            for (Rectangle rect : this.m_testRects) {
                g.drawRect(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    private IResourceTreeNode getNodeWithUpChildren(IResourceTreeNode[] nodes) {
        IResourceTreeNode result = null;
        for (int i = 0; i < nodes.length; ++i) {
            if (!nodes[i].hasUpChildren()) continue;
            result = nodes[i];
        }
        return result;
    }

    private void swapNodes(Rectangle[] rects, int start, int end) {
        if (end - start < 1 || rects.length <= 1) {
            return;
        }
        int x = rects[start].x;
        int space = rects[start + 1].x - (x + rects[start].width);
        for (int i = end; i >= start; --i) {
            rects[i].x = x;
            x += rects[i].width + space;
        }
    }

    public static BufferedImage getIcon(int type) {
        BufferedImage result;
        switch (type) {
            case 1: {
                result = IMG_RESOURCE;
                break;
            }
            case 2: {
                result = IMG_AUTO_GROUP;
                break;
            }
            case 3: {
                result = IMG_CLUSTER;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    static {
        NAME_FONT = new Font("sansserif.bold", 1, 11);
        DESC_FONT = new Font("sansserif.plain", 0, 8);
        SELECTED_FONT = new Font("sansserif.bold", 1, 11);
        NAME_COLOR = new Color(0, 49, 156);
        DESC_COLOR = Color.BLACK;
        LINE_COLOR = new Color(144, 144, 144);
        SOFT_LINE_COLOR = new Color(192, 192, 192);
        SELECTED_COLOR = new Color(222, 101, 45);
        TRANSPARENT_COLOR = new Color(3, 3, 3);
        LINE_STROKE = new BasicStroke(2.0f, 0, 0);
        try {
            IMG_RESOURCE = ImageUtil.loadImage((String)"images/icon_resource.gif");
            IMG_AUTO_GROUP = ImageUtil.loadImage((String)"images/icon_auto-group.gif");
            IMG_CLUSTER = ImageUtil.loadImage((String)"images/icon_cluster.gif");
            ICON_HEIGHT = IMG_CLUSTER.getHeight();
            ICON_WIDTH = IMG_CLUSTER.getWidth();
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }
}

