/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.inventory.group;

import javax.faces.application.FacesMessage;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.util.LookupUtil;

public class DeleteResourcesFromGroupUIBean {
    public String removeSelectedResources() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        ResourceGroup group = EnterpriseFacesContextUtility.getResourceGroup();
        String[] selectedResources = FacesContextUtility.getRequest().getParameterValues("selectedResources");
        int i = 0;
        if (selectedResources == null || selectedResources.length == 0) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_WARN, (String)"Nothing deleted, as no group members were selected");
            return "successOrFailure";
        }
        int[] selectedResourceInts = new int[selectedResources.length];
        for (String resourceIdString : selectedResources) {
            selectedResourceInts[i++] = Integer.parseInt(resourceIdString);
        }
        try {
            LookupUtil.getResourceGroupManager().removeResourcesFromGroup(subject, group.getId(), selectedResourceInts);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Removed the selected group members");
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)ThrowableUtil.getAllMessages((Throwable)e));
        }
        return "successOrFailure";
    }
}

