/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.inventory.group;

import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.ResourceError;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.composite.ResourceFacets;
import org.rhq.core.domain.resource.composite.ResourcePermission;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.GroupDefinition;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.resource.group.composite.ResourceGroupComposite;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.WebUserPreferences;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourceGroupUIBean {
    public static final String MANAGED_BEAN_NAME = "ResourceGroupUIBean";
    private ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();
    private ResourceGroup resourceGroup;
    private Double availability;
    private long count;
    private long upCount;
    private long downCount;
    private ResourcePermission permissions;
    private ResourceFacets facets;
    private Boolean isFavorite;
    private ResourceError invalidPluginConfigurationError;
    private Subject subject;

    public ResourceGroupUIBean() {
        this(ResourceGroupUIBean.lookupResourceGroup());
    }

    public ResourceGroupUIBean(ResourceGroupComposite resourceGroupComposite) {
        this(resourceGroupComposite, EnterpriseFacesContextUtility.getSubject());
    }

    public ResourceGroupUIBean(ResourceGroupComposite resourceGroupComposite, Subject subject) {
        this.resourceGroup = resourceGroupComposite.getResourceGroup();
        this.upCount = resourceGroupComposite.getExplicitUp();
        this.downCount = resourceGroupComposite.getExplicitDown();
        this.count = this.upCount + this.downCount;
        this.availability = resourceGroupComposite.getExplicitAvail();
        this.subject = subject;
        Set permissions = LookupUtil.getAuthorizationManager().getImplicitGroupPermissions(subject, this.resourceGroup.getId());
        this.permissions = new ResourcePermission(permissions);
        if (this.resourceGroup.getGroupCategory() == GroupCategory.COMPATIBLE) {
            this.facets = this.resourceTypeManager.getResourceFacets(this.resourceGroup.getResourceType().getId());
        }
    }

    public int getGroupId() {
        return this.resourceGroup.getId();
    }

    @NotNull
    public String getName() {
        return this.resourceGroup.getName();
    }

    @NotNull
    public String getGroupCategoryName() {
        return this.resourceGroup.getGroupCategory().name();
    }

    public boolean isCompatible() {
        return this.resourceGroup.getGroupCategory() == GroupCategory.COMPATIBLE;
    }

    public boolean isClusterGroup() {
        return this.resourceGroup.getClusterKey() != null;
    }

    public String getDescription() {
        return this.resourceGroup.getDescription();
    }

    public long getCtime() {
        return this.resourceGroup.getCtime();
    }

    public long getMtime() {
        return this.resourceGroup.getMtime();
    }

    public Subject getModifiedBy() {
        return this.resourceGroup.getModifiedBy();
    }

    public String getLocation() {
        return this.resourceGroup.getLocation();
    }

    public Boolean getRecursive() {
        return this.resourceGroup.isRecursive();
    }

    public GroupDefinition getGroupDefinition() {
        return this.resourceGroup.getGroupDefinition();
    }

    public ResourcePermission getPermissions() {
        return this.permissions;
    }

    public ResourceFacets getFacets() {
        return this.facets;
    }

    @Nullable
    public ResourceError getInvalidPluginConfigurationError() {
        return this.invalidPluginConfigurationError;
    }

    public Double getAvailability() {
        return this.availability;
    }

    public ResourceType getResourceType() {
        return this.resourceGroup.getResourceType();
    }

    public long getGroupCount() {
        return this.count;
    }

    public long getUpCount() {
        return this.upCount;
    }

    public long getDownCount() {
        return this.downCount;
    }

    public Subject getOwner() {
        return this.subject;
    }

    public boolean isFavorite() {
        if (this.isFavorite == null) {
            WebUser user = EnterpriseFacesContextUtility.getWebUser();
            WebUserPreferences preferences = user.getWebPreferences();
            WebUserPreferences.FavoriteGroupPortletPreferences favorites = preferences.getFavoriteGroupPortletPreferences();
            this.isFavorite = favorites.isFavorite(this.getGroupId());
        }
        return this.isFavorite;
    }

    public String toggleFavorite() {
        WebUser user = EnterpriseFacesContextUtility.getWebUser();
        WebUserPreferences preferences = user.getWebPreferences();
        WebUserPreferences.FavoriteGroupPortletPreferences favorites = preferences.getFavoriteGroupPortletPreferences();
        boolean isFav = favorites.isFavorite(this.getGroupId());
        if (isFav) {
            favorites.removeFavorite(this.getGroupId());
        } else {
            favorites.addFavorite(this.getGroupId());
        }
        preferences.setFavoriteGroupPortletPreferences(favorites);
        this.isFavorite = !isFav;
        return null;
    }

    private static ResourceGroupComposite lookupResourceGroup() {
        int resourceGroupId = (Integer)FacesContextUtility.getRequiredRequestParameter((String)"groupId", Integer.class);
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        return LookupUtil.getResourceGroupManager().getResourceGroupComposite(subject, resourceGroupId);
    }
}

