/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.inventory.resource;

import javax.faces.application.FacesMessage;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PluginConfigurationUpdate;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.gui.configuration.ConfigurationMaskingUtility;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.configuration.AbstractConfigurationUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ConnectionPropertiesUIBean
extends AbstractConfigurationUIBean {
    public static final String MANAGED_BEAN_NAME = "ConnectionPropertiesUIBean";
    private ConfigurationManagerLocal configurationManager = LookupUtil.getConfigurationManager();

    public ConnectionPropertiesUIBean() {
        this.removeSessionScopedBeanIfInView("/rhq/resource/inventory/view-connection.xhtml", ConnectionPropertiesUIBean.class);
    }

    @Nullable
    protected ConfigurationDefinition lookupConfigurationDefinition() {
        int resourceTypeId = EnterpriseFacesContextUtility.getResource().getResourceType().getId();
        ConfigurationDefinition configurationDefinition = this.configurationManager.getPluginConfigurationDefinitionForResourceType(EnterpriseFacesContextUtility.getSubject(), resourceTypeId);
        return configurationDefinition;
    }

    @Nullable
    protected Configuration lookupConfiguration() {
        Configuration configuration = this.configurationManager.getPluginConfiguration(EnterpriseFacesContextUtility.getSubject(), EnterpriseFacesContextUtility.getResource().getId());
        if (configuration != null) {
            ConfigurationMaskingUtility.maskConfiguration((Configuration)configuration, (ConfigurationDefinition)this.getConfigurationDefinition());
        }
        return configuration;
    }

    protected int getConfigurationDefinitionKey() {
        return EnterpriseFacesContextUtility.getResource().getResourceType().getId();
    }

    protected int getConfigurationKey() {
        return EnterpriseFacesContextUtility.getResource().getId();
    }

    public String getNullConfigurationDefinitionMessage() {
        return "Can not find this resource's plugin configuration definition.";
    }

    public String getNullConfigurationMessage() {
        return "This resource's plugin configuration has not been initialized.";
    }

    public String edit() {
        return "success";
    }

    public String history() {
        return "success";
    }

    public String update() {
        ConfigurationMaskingUtility.unmaskConfiguration((Configuration)this.getConfiguration(), (ConfigurationDefinition)this.getConfigurationDefinition());
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        Resource resource = EnterpriseFacesContextUtility.getResource();
        Configuration newConfiguration = this.getConfiguration();
        PluginConfigurationUpdate update = this.configurationManager.updatePluginConfiguration(subject, resource.getId(), newConfiguration);
        String errorMessage = update.getErrorMessage();
        if (errorMessage == null) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Connection properties updated.");
            this.clearConfiguration();
            return "success";
        }
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Unable to update this resource's connection properties.", (String)errorMessage);
        return "failure";
    }

    public String cancel() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Connection properties not updated.");
        return "success";
    }

    public String finish() {
        return "success";
    }
}

