/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.inventory.resource;

import java.util.ArrayList;
import java.util.HashMap;
import javax.faces.application.FacesMessage;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.gui.util.StringUtility;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.resource.ResourceFactoryManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class DeleteResourcesUIBean {
    private static final int NUM_DISPLAYED_FAILURES = 3;

    public String deleteSelectedResources() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selectedResources = FacesContextUtility.getRequest().getParameterValues("selectedResources");
        ResourceFactoryManagerLocal resourceFactoryManager = LookupUtil.getResourceFactoryManager();
        ArrayList<String> successes = new ArrayList<String>();
        HashMap<String, String> failures = new HashMap<String, String>();
        if (selectedResources == null) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_WARN, (String)"No resources selected for deletion");
            return "successOrFailure";
        }
        for (String resourceIdString : selectedResources) {
            try {
                int resourceId = Integer.parseInt(resourceIdString);
                resourceFactoryManager.deleteResource(subject, resourceId);
                successes.add(resourceIdString);
            }
            catch (Exception e) {
                String errorMessages = ThrowableUtil.getAllMessages((Throwable)e, (boolean)true);
                failures.put(resourceIdString, errorMessages);
            }
        }
        if (successes.size() > 0) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Deleted the following resources: " + StringUtility.getListAsDelimitedString(successes)));
        }
        int errorCount = 0;
        ArrayList<String> additionalErrorIds = new ArrayList<String>();
        for (String errorResourceId : failures.keySet()) {
            if (errorCount < 3) {
                String errorMessage = (String)failures.get(errorResourceId);
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to delete resource: " + errorResourceId + ". Cause: " + errorMessage));
            } else {
                additionalErrorIds.add(errorResourceId);
            }
            ++errorCount;
        }
        if (additionalErrorIds.size() > 0) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Full errors not shown for resources that failed to delete: " + StringUtility.getListAsDelimitedString(additionalErrorIds)));
        }
        return "successOrFailure";
    }
}

